/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.proxies;

import com.stackhawk.hste.extension.api.ApiAction;
import com.stackhawk.hste.extension.api.ApiException;
import com.stackhawk.hste.extension.api.ApiImplementor;
import com.stackhawk.hste.extension.api.ApiResponse;
import com.stackhawk.hste.extension.api.ApiResponseElement;
import com.stackhawk.hste.extension.api.ApiResponseList;
import com.stackhawk.hste.extension.api.ApiResponseSet;
import com.stackhawk.hste.extension.api.ApiView;
import com.stackhawk.hste.extension.proxies.ExtensionProxies;
import com.stackhawk.hste.extension.proxies.ProxiesParamProxy;
import java.util.HashMap;
import net.sf.json.JSONObject;

@Deprecated
public class ProxiesAPI
extends ApiImplementor {
    private static final String PREFIX = "localProxies";
    private static final String VIEW_ADDITIONAL_PROXIES = "additionalProxies";
    private static final String ACTION_ADD_PROXY = "addAdditionalProxy";
    private static final String ACTION_REMOVE_PROXY = "removeAdditionalProxy";
    private static final String PARAM_ADDRESS = "address";
    private static final String PARAM_PORT = "port";
    private static final String PARAM_BEHIND_NAT = "behindNat";
    private static final String PARAM_DECODE_ZIP = "alwaysDecodeZip";
    private static final String PARAM_REM_UNSUPPORTED_ENC = "removeUnsupportedEncodings";
    private ExtensionProxies extension = null;

    public ProxiesAPI(ExtensionProxies ext) {
        this.extension = ext;
        this.addApiView(new ApiView(VIEW_ADDITIONAL_PROXIES));
        this.addApiAction(new ApiAction(ACTION_ADD_PROXY, new String[]{PARAM_ADDRESS, PARAM_PORT}, new String[]{PARAM_BEHIND_NAT, PARAM_DECODE_ZIP, PARAM_REM_UNSUPPORTED_ENC}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_PROXY, new String[]{PARAM_ADDRESS, PARAM_PORT}));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        if (VIEW_ADDITIONAL_PROXIES.equals(name)) {
            ApiResponseList response = new ApiResponseList(name);
            for (ProxiesParamProxy p : this.extension.getAdditionalProxies()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(PARAM_ADDRESS, p.getAddress());
                map.put(PARAM_PORT, Integer.toString(p.getPort()));
                map.put("enabled", Boolean.toString(p.isEnabled()));
                map.put(PARAM_BEHIND_NAT, Boolean.toString(p.isBehindNat()));
                map.put(PARAM_DECODE_ZIP, Boolean.toString(p.isAlwaysDecodeGzip()));
                map.put(PARAM_REM_UNSUPPORTED_ENC, Boolean.toString(p.isRemoveUnsupportedEncodings()));
                response.addItem(new ApiResponseSet("proxy", map));
            }
            return response;
        }
        throw new ApiException(ApiException.Type.BAD_VIEW, name);
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        if (ACTION_ADD_PROXY.equals(name)) {
            try {
                this.extension.addProxy(new ProxiesParamProxy(params.getString(PARAM_ADDRESS), params.getInt(PARAM_PORT), true, false, this.getParam(params, PARAM_REM_UNSUPPORTED_ENC, false), this.getParam(params, PARAM_DECODE_ZIP, false), this.getParam(params, PARAM_BEHIND_NAT, false)));
                return ApiResponseElement.OK;
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, e.getMessage());
            }
        }
        if (ACTION_REMOVE_PROXY.equals(name)) {
            try {
                this.extension.removeProxy(params.getString(PARAM_ADDRESS), params.getInt(PARAM_PORT));
                return ApiResponseElement.OK;
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, e.getMessage());
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW, name);
    }
}

