/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.pscan;

import com.stackhawk.hste.extension.pscan.ExtensionPassiveScan;
import com.stackhawk.hste.extension.pscan.PassiveScanParam;
import com.stackhawk.hste.utils.HsteHtmlLabel;
import com.stackhawk.hste.utils.HsteNumberSpinner;
import com.stackhawk.hste.utils.I18N;
import com.stackhawk.hste.view.LayoutHelper;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;

class PassiveScannerOptionsPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private final JCheckBox scanOnlyInScopeCheckBox;
    private final JCheckBox scanFuzzerMessagesCheckBox;
    private final HsteNumberSpinner passiveScanThreads;
    private final HsteNumberSpinner maxAlertsPerRule;
    private final HsteNumberSpinner maxBodySizeInBytes;
    private final JButton clearQueue;

    public PassiveScannerOptionsPanel(ExtensionPassiveScan extPassiveScan, I18N messages) {
        this.setName(messages.getString("pscan.options.main.name"));
        this.scanOnlyInScopeCheckBox = new JCheckBox(messages.getString("pscan.options.main.label.scanOnlyInScope"));
        this.scanFuzzerMessagesCheckBox = new JCheckBox(messages.getString("pscan.options.main.label.scanFuzzerMessages"));
        this.passiveScanThreads = new HsteNumberSpinner(1, Constant.getDefaultThreadCount(), 50);
        this.maxAlertsPerRule = new HsteNumberSpinner();
        this.maxBodySizeInBytes = new HsteNumberSpinner();
        this.clearQueue = new JButton(messages.getString("pscan.options.main.label.clearQueue"));
        this.clearQueue.addActionListener(al -> extPassiveScan.clearQueue());
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add((Component)this.scanOnlyInScopeCheckBox, LayoutHelper.getGBC(0, ++y, 2, 1.0));
        this.add((Component)this.scanFuzzerMessagesCheckBox, LayoutHelper.getGBC(0, ++y, 2, 1.0));
        JLabel pscanThreadsLabel = new JLabel(messages.getString("pscan.options.main.label.threads"));
        pscanThreadsLabel.setLabelFor(this.passiveScanThreads);
        this.add((Component)pscanThreadsLabel, LayoutHelper.getGBC(0, ++y, 1, 1.0));
        this.add((Component)this.passiveScanThreads, LayoutHelper.getGBC(1, y, 1, 1.0));
        JLabel maxAlertsLabel = new JLabel(messages.getString("pscan.options.main.label.maxAlertsPerRule"));
        maxAlertsLabel.setLabelFor(this.maxAlertsPerRule);
        this.add((Component)maxAlertsLabel, LayoutHelper.getGBC(0, ++y, 1, 1.0));
        this.add((Component)this.maxAlertsPerRule, LayoutHelper.getGBC(1, y, 1, 1.0));
        JLabel maxBodySizeLabel = new JLabel(messages.getString("pscan.options.main.label.maxBodySizeInBytes"));
        maxBodySizeLabel.setLabelFor(this.maxBodySizeInBytes);
        this.add((Component)maxBodySizeLabel, LayoutHelper.getGBC(0, ++y, 1, 1.0));
        this.add((Component)this.maxBodySizeInBytes, LayoutHelper.getGBC(1, y, 1, 1.0));
        this.add((Component)this.clearQueue, LayoutHelper.getGBC(1, ++y, 1, 0.5));
        this.add((Component)new HsteHtmlLabel(messages.getString("pscan.options.main.footer.threadsApply")), LayoutHelper.getGBC(0, ++y, 2, 1.0));
        this.add((Component)new JLabel(""), LayoutHelper.getGBC(0, ++y, 2, 1.0, 1.0));
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam optionsParam = (OptionsParam)obj;
        PassiveScanParam pscanOptions = optionsParam.getParamSet(PassiveScanParam.class);
        this.scanOnlyInScopeCheckBox.setSelected(pscanOptions.isScanOnlyInScope());
        this.scanFuzzerMessagesCheckBox.setSelected(pscanOptions.isScanFuzzerMessages());
        this.passiveScanThreads.setValue(pscanOptions.getPassiveScanThreads());
        this.maxAlertsPerRule.setValue(pscanOptions.getMaxAlertsPerRule());
        this.maxBodySizeInBytes.setValue(pscanOptions.getMaxBodySizeInBytesToScan());
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam optionsParam = (OptionsParam)obj;
        PassiveScanParam pscanOptions = optionsParam.getParamSet(PassiveScanParam.class);
        pscanOptions.setScanOnlyInScope(this.scanOnlyInScopeCheckBox.isSelected());
        pscanOptions.setScanFuzzerMessages(this.scanFuzzerMessagesCheckBox.isSelected());
        pscanOptions.setPassiveScanThreads(this.passiveScanThreads.getValue());
        pscanOptions.setMaxAlertsPerRule(this.maxAlertsPerRule.getValue());
        pscanOptions.setMaxBodySizeInBytesToScan(this.maxBodySizeInBytes.getValue());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.pscan.main";
    }
}

