/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.script;

import com.stackhawk.hste.extension.script.ExtensionScript;
import com.stackhawk.hste.extension.script.HttpSenderScript;
import com.stackhawk.hste.extension.script.HttpSenderScriptHelper;
import com.stackhawk.hste.extension.script.ScriptsCache;
import com.stackhawk.hste.network.HttpSenderListener;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;

class HttpSenderScriptListener
implements HttpSenderListener {
    private final ScriptsCache<HttpSenderScript> scriptsCache;

    public HttpSenderScriptListener(ExtensionScript extension) {
        this.scriptsCache = extension.createScriptsCache(ScriptsCache.Configuration.builder().setScriptType("httpsender").setTargetInterface(HttpSenderScript.class).setInterfaceErrorMessageProvider(sw -> Constant.messages.getString("script.interface.httpsender.error")).build());
    }

    @Override
    public int getListenerOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onHttpRequestSend(HttpMessage msg, int initiator, HttpSender sender) {
        this.scriptsCache.refresh();
        HttpSenderScriptHelper scriptHelper = new HttpSenderScriptHelper(sender);
        this.scriptsCache.execute(script -> script.sendingRequest(msg, initiator, scriptHelper));
    }

    @Override
    public void onHttpResponseReceive(HttpMessage msg, int initiator, HttpSender sender) {
        HttpSenderScriptHelper scriptHelper = new HttpSenderScriptHelper(sender);
        this.scriptsCache.execute(script -> script.responseReceived(msg, initiator, scriptHelper));
    }
}

