/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.script;

import com.stackhawk.hste.extension.script.ExtensionScript;
import com.stackhawk.hste.extension.script.ProxyScript;
import com.stackhawk.hste.extension.script.ScriptsCache;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.network.HttpMessage;

public class ProxyListenerScript
implements ProxyListener {
    public static final int PROXY_LISTENER_ORDER = 4998;
    private final ExtensionScript extension;
    private final ScriptsCache<ProxyScript> scripts;

    public ProxyListenerScript(ExtensionScript extension) {
        this.extension = extension;
        this.scripts = extension.createScriptsCache(ScriptsCache.Configuration.builder().setScriptType("proxy").setTargetInterface(ProxyScript.class).setInterfaceErrorMessageProvider(sw -> Constant.messages.getString("script.interface.proxy.error")).build());
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 4998;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage msg) {
        this.scripts.refresh();
        return this.invokeProxyScripts(msg, true);
    }

    private boolean invokeProxyScripts(HttpMessage msg, boolean request) {
        for (ScriptsCache.CachedScript<ProxyScript> cachedScript : this.scripts.getCachedScripts()) {
            ProxyScript script = cachedScript.getScript();
            try {
                boolean forwardMessage = request ? script.proxyRequest(msg) : script.proxyResponse(msg);
                if (forwardMessage) continue;
                return false;
            }
            catch (Exception e) {
                this.extension.handleScriptException(cachedScript.getScriptWrapper(), e);
            }
        }
        return true;
    }

    @Override
    public boolean onHttpResponseReceive(HttpMessage msg) {
        return this.invokeProxyScripts(msg, false);
    }
}

