/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.script;

import com.stackhawk.hste.extension.script.ScriptType;
import com.stackhawk.hste.extension.script.ScriptWrapper;
import javax.swing.tree.DefaultMutableTreeNode;
import org.parosproxy.paros.Constant;

public class ScriptNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private String nodeName = null;
    private ScriptType type = null;
    private boolean template = false;

    public ScriptNode() {
        this.nodeName = Constant.messages.getString("script.tree.root");
    }

    public ScriptNode(boolean template) {
        this.template = template;
        this.nodeName = template ? Constant.messages.getString("script.tree.templates") : Constant.messages.getString("script.tree.scripts");
    }

    public ScriptNode(ScriptType type, boolean template) {
        this.nodeName = Constant.messages.getString(type.getI18nKey());
        this.type = type;
        this.template = template;
    }

    public ScriptNode(String name) {
        this.nodeName = name;
    }

    public ScriptNode(ScriptWrapper script) {
        this(script, false);
    }

    public ScriptNode(ScriptWrapper script, boolean template) {
        this.nodeName = script.getName();
        this.type = script.getType();
        this.template = template;
        this.setUserObject(script);
    }

    @Override
    public String toString() {
        return this.nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String name) {
        this.nodeName = name;
    }

    @Override
    public ScriptNode getParent() {
        return (ScriptNode)super.getParent();
    }

    public ScriptType getType() {
        return this.type;
    }

    public boolean isTemplate() {
        return this.template;
    }
}

