/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.search;

import com.stackhawk.hste.extension.httppanel.HttpPanel;
import com.stackhawk.hste.extension.search.ExtensionSearch;
import com.stackhawk.hste.extension.search.SearchMatch;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.parosproxy.paros.network.HttpMessage;

public class SearchResult {
    private ExtensionSearch.Type type;
    private String customSearcherName;
    private HttpMessage message;
    private String regEx;
    private String stringFound;
    private List<SearchMatch> matches = null;
    private SearchMatch lastMatch = null;

    public SearchResult(ExtensionSearch.Type type, String regEx, String stringFound, SearchMatch sm) {
        this(type, null, regEx, stringFound, sm);
    }

    public SearchResult(ExtensionSearch.Type type, String customSearcherName, String regEx, String stringFound, SearchMatch sm) {
        this.message = sm.getMessage();
        this.type = type;
        this.customSearcherName = customSearcherName;
        this.regEx = regEx;
        this.stringFound = stringFound;
        this.matches = new ArrayList<SearchMatch>(1);
        this.matches.add(sm);
    }

    public SearchResult(HttpMessage message, ExtensionSearch.Type type, String regEx, String stringFound) {
        this.message = message;
        this.type = type;
        this.regEx = regEx;
        this.stringFound = stringFound;
    }

    public String getRegEx() {
        return this.regEx;
    }

    public String getStringFound() {
        return this.stringFound;
    }

    public void setStringFound(String stringFound) {
        this.stringFound = stringFound;
    }

    public HttpMessage getMessage() {
        return this.message;
    }

    public void setMessage(HttpMessage message) {
        this.message = message;
    }

    public ExtensionSearch.Type getType() {
        return this.type;
    }

    public String getCustomSearcherName() {
        return this.customSearcherName;
    }

    public void setType(ExtensionSearch.Type type) {
        this.type = type;
    }

    public SearchMatch getFirstMatch(HttpPanel reqPanel, HttpPanel resPanel) {
        if (this.matches == null) {
            this.enumerateMatches(reqPanel, resPanel);
        }
        if (this.matches.size() > 0) {
            this.lastMatch = this.matches.get(0);
            return this.lastMatch;
        }
        return null;
    }

    public SearchMatch getLastMatch(HttpPanel reqPanel, HttpPanel resPanel) {
        if (this.matches == null) {
            this.enumerateMatches(reqPanel, resPanel);
        }
        if (this.matches.size() > 0) {
            this.lastMatch = this.matches.get(this.matches.size() - 1);
            return this.lastMatch;
        }
        return null;
    }

    public SearchMatch getNextMatch() {
        int i;
        if (this.lastMatch != null && (i = this.matches.indexOf(this.lastMatch)) >= 0 && i < this.matches.size() - 1) {
            this.lastMatch = this.matches.get(i + 1);
            return this.lastMatch;
        }
        return null;
    }

    public SearchMatch getPrevMatch() {
        int i;
        if (this.lastMatch != null && (i = this.matches.indexOf(this.lastMatch)) >= 1) {
            this.lastMatch = this.matches.get(i - 1);
            return this.lastMatch;
        }
        return null;
    }

    private void enumerateMatches(HttpPanel reqPanel, HttpPanel resPanel) {
        this.matches = new ArrayList<SearchMatch>();
        Pattern p = Pattern.compile(this.regEx, 10);
        if (ExtensionSearch.Type.URL.equals((Object)this.type)) {
            reqPanel.headerSearch(p, this.matches);
            return;
        }
        if (ExtensionSearch.Type.Header.equals((Object)this.type)) {
            reqPanel.headerSearch(p, this.matches);
            return;
        }
        if (ExtensionSearch.Type.All.equals((Object)this.type) || ExtensionSearch.Type.Request.equals((Object)this.type)) {
            reqPanel.headerSearch(p, this.matches);
            reqPanel.bodySearch(p, this.matches);
        }
        if (ExtensionSearch.Type.All.equals((Object)this.type) || ExtensionSearch.Type.Response.equals((Object)this.type)) {
            resPanel.headerSearch(p, this.matches);
            resPanel.bodySearch(p, this.matches);
        }
    }
}

