/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.spider;

import com.stackhawk.hste.extension.spider.ExtensionSpider;
import com.stackhawk.hste.extension.spider.SpiderScan;
import com.stackhawk.hste.model.ScanController;
import com.stackhawk.hste.model.Target;
import com.stackhawk.hste.spider.SpiderParam;
import com.stackhawk.hste.spider.filters.FetchFilter;
import com.stackhawk.hste.spider.filters.MaxChildrenFetchFilter;
import com.stackhawk.hste.spider.filters.MaxChildrenParseFilter;
import com.stackhawk.hste.spider.filters.ParseFilter;
import com.stackhawk.hste.spider.parser.SpiderParser;
import com.stackhawk.hste.users.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.httpclient.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class SpiderScanController
implements ScanController<SpiderScan> {
    private static final Logger log = LogManager.getLogger(SpiderScanController.class);
    private ExtensionSpider extension;
    private final Lock spiderScansLock = new ReentrantLock();
    private int scanIdCounter;
    private Map<Integer, SpiderScan> spiderScanMap;
    private List<SpiderScan> spiderScanList;

    public SpiderScanController(ExtensionSpider extension) {
        this.extension = extension;
        this.spiderScanMap = new HashMap<Integer, SpiderScan>();
        this.spiderScanList = new ArrayList<SpiderScan>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startScan(String name, Target target, User user, Object[] contextSpecificObjects) {
        this.spiderScansLock.lock();
        try {
            int id = this.scanIdCounter++;
            SpiderParam spiderParams = this.extension.getSpiderParam();
            ArrayList<SpiderParser> customSpiderParsers = new ArrayList<SpiderParser>();
            ArrayList<FetchFilter> customFetchFilters = new ArrayList<FetchFilter>();
            ArrayList<ParseFilter> customParseFilters = new ArrayList<ParseFilter>();
            URI startUri = null;
            if (contextSpecificObjects != null) {
                for (Object obj : contextSpecificObjects) {
                    if (obj instanceof SpiderParam) {
                        log.debug("Setting custom spider params");
                        spiderParams = (SpiderParam)obj;
                        continue;
                    }
                    if (obj instanceof SpiderParser) {
                        customSpiderParsers.add((SpiderParser)obj);
                        continue;
                    }
                    if (obj instanceof FetchFilter) {
                        customFetchFilters.add((FetchFilter)obj);
                        continue;
                    }
                    if (obj instanceof ParseFilter) {
                        customParseFilters.add((ParseFilter)obj);
                        continue;
                    }
                    if (obj instanceof URI) {
                        startUri = (URI)obj;
                        continue;
                    }
                    log.error("Unexpected contextSpecificObject: {}", (Object)obj.getClass().getCanonicalName());
                }
            }
            if (spiderParams.getMaxChildren() > 0) {
                MaxChildrenFetchFilter maxChildrenFetchFilter = new MaxChildrenFetchFilter();
                maxChildrenFetchFilter.setMaxChildren(spiderParams.getMaxChildren());
                maxChildrenFetchFilter.setModel(this.extension.getModel());
                MaxChildrenParseFilter maxChildrenParseFilter = new MaxChildrenParseFilter(this.extension.getMessages());
                maxChildrenParseFilter.setMaxChildren(spiderParams.getMaxChildren());
                maxChildrenParseFilter.setModel(this.extension.getModel());
                customFetchFilters.add(maxChildrenFetchFilter);
                customParseFilters.add(maxChildrenParseFilter);
            }
            SpiderScan scan = new SpiderScan(this.extension, spiderParams, target, startUri, user, id, name);
            scan.setCustomSpiderParsers(customSpiderParsers);
            scan.setCustomFetchFilters(customFetchFilters);
            scan.setCustomParseFilters(customParseFilters);
            this.spiderScanMap.put(id, scan);
            this.spiderScanList.add(scan);
            scan.start();
            int n = id;
            return n;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    @Override
    public SpiderScan getScan(int id) {
        return this.spiderScanMap.get(id);
    }

    @Override
    public SpiderScan getLastScan() {
        this.spiderScansLock.lock();
        try {
            if (this.spiderScanList.isEmpty()) {
                SpiderScan spiderScan = null;
                return spiderScan;
            }
            SpiderScan spiderScan = this.spiderScanList.get(this.spiderScanList.size() - 1);
            return spiderScan;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SpiderScan> getAllScans() {
        ArrayList<SpiderScan> list = new ArrayList<SpiderScan>();
        this.spiderScansLock.lock();
        try {
            for (SpiderScan scan : this.spiderScanList) {
                list.add(scan);
            }
            ArrayList<SpiderScan> arrayList = list;
            return arrayList;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SpiderScan> getActiveScans() {
        ArrayList<SpiderScan> list = new ArrayList<SpiderScan>();
        this.spiderScansLock.lock();
        try {
            for (SpiderScan scan : this.spiderScanList) {
                if (scan.isStopped()) continue;
                list.add(scan);
            }
            ArrayList<SpiderScan> arrayList = list;
            return arrayList;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpiderScan removeScan(int id) {
        this.spiderScansLock.lock();
        try {
            SpiderScan ascan = this.spiderScanMap.get(id);
            if (!this.spiderScanMap.containsKey(id)) {
                SpiderScan spiderScan = null;
                return spiderScan;
            }
            ascan.stopScan();
            ascan.clear();
            this.spiderScanMap.remove(id);
            this.spiderScanList.remove(ascan);
            SpiderScan spiderScan = ascan;
            return spiderScan;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    public int getTotalNumberScans() {
        return this.spiderScanMap.size();
    }

    @Override
    public void stopAllScans() {
        this.spiderScansLock.lock();
        try {
            for (SpiderScan scan : this.spiderScanMap.values()) {
                scan.stopScan();
            }
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    @Override
    public void pauseAllScans() {
        this.spiderScansLock.lock();
        try {
            for (SpiderScan scan : this.spiderScanMap.values()) {
                scan.pauseScan();
            }
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    @Override
    public void resumeAllScans() {
        this.spiderScansLock.lock();
        try {
            for (SpiderScan scan : this.spiderScanMap.values()) {
                scan.resumeScan();
            }
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAllScans() {
        this.spiderScansLock.lock();
        try {
            int count = 0;
            Iterator<SpiderScan> it = this.spiderScanMap.values().iterator();
            while (it.hasNext()) {
                SpiderScan ascan = it.next();
                ascan.stopScan();
                ascan.clear();
                it.remove();
                this.spiderScanList.remove(ascan);
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeFinishedScans() {
        this.spiderScansLock.lock();
        try {
            int count = 0;
            Iterator<SpiderScan> it = this.spiderScanMap.values().iterator();
            while (it.hasNext()) {
                SpiderScan scan = it.next();
                if (!scan.isStopped()) continue;
                scan.stopScan();
                scan.clear();
                it.remove();
                this.spiderScanList.remove(scan);
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    @Override
    public void stopScan(int id) {
        this.spiderScansLock.lock();
        try {
            if (this.spiderScanMap.containsKey(id)) {
                this.spiderScanMap.get(id).stopScan();
            }
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    @Override
    public void pauseScan(int id) {
        this.spiderScansLock.lock();
        try {
            if (this.spiderScanMap.containsKey(id)) {
                this.spiderScanMap.get(id).pauseScan();
            }
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    @Override
    public void resumeScan(int id) {
        this.spiderScansLock.lock();
        try {
            if (this.spiderScanMap.containsKey(id)) {
                this.spiderScanMap.get(id).resumeScan();
            }
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }

    public void reset() {
        this.removeAllScans();
        this.spiderScansLock.lock();
        try {
            this.scanIdCounter = 0;
        }
        finally {
            this.spiderScansLock.unlock();
        }
    }
}

