/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.stats;

import com.stackhawk.hste.extension.stats.InMemoryStats;
import com.stackhawk.hste.extension.stats.OptionsStatsPanel;
import com.stackhawk.hste.extension.stats.StatsAPI;
import com.stackhawk.hste.extension.stats.StatsParam;
import com.stackhawk.hste.extension.stats.Statsd;
import com.stackhawk.hste.utils.Stats;
import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.model.OptionsParam;

public class ExtensionStats
extends ExtensionAdaptor
implements OptionsChangedListener {
    public static final String NAME = "ExtensionStats";
    private InMemoryStats inMemStats;
    private Statsd statsd;
    private OptionsStatsPanel optionsStatsPanel;
    private StatsParam statsParam;
    private static final Logger LOGGER = LogManager.getLogger(ExtensionStats.class);

    public ExtensionStats() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("stats.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsChangedListener(this);
        extensionHook.addOptionsParamSet(this.getStatsParam());
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsStatsPanel());
        }
        StatsAPI statsAPI = new StatsAPI(this);
        extensionHook.addApiImplementor(statsAPI);
        statsAPI.addApiOptions(this.getStatsParam());
    }

    @Override
    public void optionsLoaded() {
        this.optionsChanged();
    }

    private OptionsStatsPanel getOptionsStatsPanel() {
        if (this.optionsStatsPanel == null) {
            this.optionsStatsPanel = new OptionsStatsPanel();
        }
        return this.optionsStatsPanel;
    }

    private StatsParam getStatsParam() {
        if (this.statsParam == null) {
            this.statsParam = new StatsParam();
        }
        return this.statsParam;
    }

    @Override
    public boolean isCore() {
        return true;
    }

    @Override
    public String getAuthor() {
        return "HSTE Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("stats.desc");
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public void optionsChanged(OptionsParam optionsParam) {
        this.optionsChanged();
    }

    private void optionsChanged() {
        boolean statsdInit;
        boolean inMemStatsInit;
        boolean bl = inMemStatsInit = this.inMemStats != null;
        if (inMemStatsInit != this.getStatsParam().isInMemoryEnabled()) {
            if (!inMemStatsInit) {
                LOGGER.info("Start recording in memory stats");
                this.inMemStats = new InMemoryStats();
                Stats.addListener(this.inMemStats);
            } else {
                LOGGER.info("Stop recording in memory stats");
                Stats.removeListener(this.inMemStats);
                this.inMemStats.allCleared();
                this.inMemStats = null;
            }
        }
        boolean bl2 = statsdInit = this.statsd != null;
        if (statsdInit != this.getStatsParam().isStatsdEnabled()) {
            if (!statsdInit) {
                LOGGER.info("Start sending stats to statsd server");
                try {
                    this.statsd = this.newStatsD(this.getStatsParam());
                    Stats.addListener(this.statsd);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            } else {
                LOGGER.info("Stop sending stats to statsd server");
                Stats.removeListener(this.statsd);
                this.statsd = null;
            }
        } else if (statsdInit) {
            if (!StringUtils.equals((CharSequence)this.getStatsParam().getStatsdHost(), (CharSequence)this.statsd.getHost()) || this.getStatsParam().getStatsdPort() != this.statsd.getPort()) {
                LOGGER.info("Restart sending stats to statsd server");
                try {
                    Stats.removeListener(this.statsd);
                    this.statsd = this.newStatsD(this.getStatsParam());
                    Stats.addListener(this.statsd);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            } else if (!StringUtils.equals((CharSequence)this.getStatsParam().getStatsdPrefix(), (CharSequence)this.statsd.getPrefix())) {
                this.statsd.setPrefix(this.getStatsParam().getStatsdPrefix());
            }
        }
    }

    private Statsd newStatsD(StatsParam param) throws UnknownHostException, IOException {
        return new Statsd(param.getStatsdHost(), param.getStatsdPort(), param.getStatsdPrefix());
    }

    public InMemoryStats getInMemoryStats() {
        return this.inMemStats;
    }
}

