/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.stats;

import com.stackhawk.hste.extension.stats.StatsParam;
import com.stackhawk.hste.utils.FontUtils;
import com.stackhawk.hste.utils.HstePortNumberSpinner;
import com.stackhawk.hste.utils.HsteTextField;
import com.stackhawk.hste.view.LayoutHelper;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;

public class OptionsStatsPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelMisc;
    private JCheckBox inMemoryStatsEnabledField;
    private JCheckBox statsdStatsEnabledField;
    private HsteTextField statsdHostField;
    private HstePortNumberSpinner statsdPortField;
    private HsteTextField statsdPrefixField;

    public OptionsStatsPanel() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("stats.options.title"));
        this.add((Component)this.getPanelMisc(), this.getPanelMisc().getName());
    }

    private JPanel getPanelMisc() {
        if (this.panelMisc == null) {
            this.panelMisc = new JPanel();
            this.panelMisc.setLayout(new GridBagLayout());
            this.panelMisc.add((Component)this.getInMemoryStatsEnabledField(), LayoutHelper.getGBC(0, 0, 1, 0.5));
            this.panelMisc.add((Component)this.getStatsdStatsEnabledField(), LayoutHelper.getGBC(0, 1, 1, 0.5));
            JPanel statsdPanel = new JPanel();
            statsdPanel.setLayout(new GridBagLayout());
            statsdPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("stats.options.statsd.panel"), 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
            statsdPanel.add((Component)new JLabel(Constant.messages.getString("stats.options.label.statsd.host")), LayoutHelper.getGBC(0, 1, 1, 0.5));
            statsdPanel.add((Component)this.getStatsdHostField(), LayoutHelper.getGBC(1, 1, 1, 0.5));
            statsdPanel.add((Component)new JLabel(Constant.messages.getString("stats.options.label.statsd.port")), LayoutHelper.getGBC(0, 2, 1, 0.5));
            statsdPanel.add((Component)this.getStatsdPortField(), LayoutHelper.getGBC(1, 2, 1, 0.5));
            statsdPanel.add((Component)new JLabel(Constant.messages.getString("stats.options.label.statsd.prefix")), LayoutHelper.getGBC(0, 3, 1, 0.5));
            statsdPanel.add((Component)this.getStatsdPrefixField(), LayoutHelper.getGBC(1, 3, 1, 0.5));
            this.panelMisc.add((Component)statsdPanel, LayoutHelper.getGBC(0, 2, 1, 1.0));
            this.panelMisc.add((Component)new JLabel(), LayoutHelper.getGBC(0, 10, 1, 0.5, 1.0));
        }
        return this.panelMisc;
    }

    private JCheckBox getInMemoryStatsEnabledField() {
        if (this.inMemoryStatsEnabledField == null) {
            this.inMemoryStatsEnabledField = new JCheckBox();
            this.inMemoryStatsEnabledField.setText(Constant.messages.getString("stats.options.mem.enabled"));
            this.inMemoryStatsEnabledField.setVerticalAlignment(1);
            this.inMemoryStatsEnabledField.setVerticalTextPosition(1);
        }
        return this.inMemoryStatsEnabledField;
    }

    private JCheckBox getStatsdStatsEnabledField() {
        if (this.statsdStatsEnabledField == null) {
            this.statsdStatsEnabledField = new JCheckBox();
            this.statsdStatsEnabledField.setText(Constant.messages.getString("stats.options.statsd.enabled"));
            this.statsdStatsEnabledField.setVerticalAlignment(1);
            this.statsdStatsEnabledField.setVerticalTextPosition(1);
            this.statsdStatsEnabledField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsStatsPanel.this.setStatsdFieldStates();
                }
            });
        }
        return this.statsdStatsEnabledField;
    }

    private void setStatsdFieldStates() {
        this.getStatsdHostField().setEnabled(this.statsdStatsEnabledField.isSelected());
        this.getStatsdPortField().setEnabled(this.statsdStatsEnabledField.isSelected());
        this.getStatsdPrefixField().setEnabled(this.statsdStatsEnabledField.isSelected());
    }

    private HsteTextField getStatsdHostField() {
        if (this.statsdHostField == null) {
            this.statsdHostField = new HsteTextField();
        }
        return this.statsdHostField;
    }

    private HstePortNumberSpinner getStatsdPortField() {
        if (this.statsdPortField == null) {
            this.statsdPortField = new HstePortNumberSpinner(0);
        }
        return this.statsdPortField;
    }

    private HsteTextField getStatsdPrefixField() {
        if (this.statsdPrefixField == null) {
            this.statsdPrefixField = new HsteTextField();
        }
        return this.statsdPrefixField;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam optionsParam = (OptionsParam)obj;
        StatsParam statsParam = optionsParam.getParamSet(StatsParam.class);
        this.getInMemoryStatsEnabledField().setSelected(statsParam.isInMemoryEnabled());
        this.getStatsdStatsEnabledField().setSelected(statsParam.isStatsdEnabled());
        this.getStatsdHostField().setText(statsParam.getStatsdHost());
        this.getStatsdHostField().discardAllEdits();
        this.getStatsdPortField().setValue(statsParam.getStatsdPort());
        this.getStatsdPrefixField().setText(statsParam.getStatsdPrefix());
        this.getStatsdPrefixField().discardAllEdits();
        this.setStatsdFieldStates();
    }

    @Override
    public void validateParam(Object obj) throws Exception {
        if (this.getStatsdStatsEnabledField().isSelected()) {
            try {
                InetAddress.getByName(this.getStatsdHostField().getText());
            }
            catch (Exception e) {
                throw new Exception(Constant.messages.getString("stats.options.error.statsd.host.bad"), e);
            }
        }
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam optionsParam = (OptionsParam)obj;
        StatsParam statsParam = optionsParam.getParamSet(StatsParam.class);
        statsParam.setInMemoryEnabled(this.getInMemoryStatsEnabledField().isSelected());
        if (this.getStatsdStatsEnabledField().isSelected()) {
            statsParam.setStatsdHost(this.getStatsdHostField().getText());
            statsParam.setStatsdPort(this.getStatsdPortField().getValue());
            statsParam.setStatsdPrefix(this.getStatsdPrefixField().getText());
        } else {
            statsParam.setStatsdHost("");
        }
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.stats";
    }
}

