/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.stats;

import com.stackhawk.hste.extension.stats.StatsdClient;
import com.stackhawk.hste.utils.StatsListener;
import java.io.IOException;
import java.net.UnknownHostException;

public class Statsd
implements StatsListener {
    private static final String GLOBAL_KEY = "global";
    private StatsdClient statsd2;
    private String host;
    private int port;
    private String prefix;
    private String separator = ".";

    public Statsd(String host, int port, String prefix) throws UnknownHostException, IOException {
        this.host = host;
        this.port = port;
        this.prefix = prefix;
        this.statsd2 = new StatsdClient(host, port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    private String getFullKey(String key) {
        return this.getFullKey(null, key);
    }

    private String getFullKey(String site, String key) {
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(this.prefix);
            sb.append(this.separator);
        }
        if (site != null) {
            sb.append(site.substring(site.indexOf(58) + 3));
        } else {
            sb.append(GLOBAL_KEY);
        }
        sb.append(this.separator);
        sb.append(key);
        return sb.toString().replace(":", "-");
    }

    @Override
    public void counterInc(String key) {
        this.statsd2.increment(this.getFullKey(key));
    }

    @Override
    public void counterInc(String site, String key) {
        this.statsd2.increment(this.getFullKey(site, key));
    }

    @Override
    public void counterInc(String key, long inc) {
        this.statsd2.increment(this.getFullKey(key), (int)inc);
    }

    @Override
    public void counterInc(String site, String key, long inc) {
        this.statsd2.increment(this.getFullKey(site, key), (int)inc);
    }

    @Override
    public void counterDec(String key) {
        this.statsd2.decrement(this.getFullKey(key));
    }

    @Override
    public void counterDec(String site, String key) {
        this.statsd2.decrement(this.getFullKey(site, key));
    }

    @Override
    public void counterDec(String key, long dec) {
        this.statsd2.decrement(this.getFullKey(key), (int)dec);
    }

    @Override
    public void counterDec(String site, String key, long dec) {
        this.statsd2.decrement(this.getFullKey(site, key), (int)dec);
    }

    @Override
    public void highwaterMarkSet(String key, long value) {
        this.statsd2.gauge(this.getFullKey(key), value);
    }

    @Override
    public void highwaterMarkSet(String site, String key, long value) {
        this.statsd2.gauge(this.getFullKey(site, key), value);
    }

    @Override
    public void lowwaterMarkSet(String key, long value) {
        this.statsd2.gauge(this.getFullKey(key), value);
    }

    @Override
    public void lowwaterMarkSet(String site, String key, long value) {
        this.statsd2.gauge(this.getFullKey(site, key), value);
    }

    @Override
    public void allCleared() {
    }

    @Override
    public void allCleared(String site) {
    }

    @Override
    public void cleared(String keyPrefix) {
    }

    @Override
    public void cleared(String site, String keyPrefix) {
    }

    @Override
    public void setStat(String key, Long value) {
    }
}

