/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.stdmenus;

import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.view.messagecontainer.MessageContainer;
import com.stackhawk.hste.view.popup.ExtensionPopupMenuMessageContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;

public abstract class PopupContextMenuItemHolder
extends ExtensionPopupMenuMessageContainer {
    private static final long serialVersionUID = 2976582263073602339L;
    private String parentName;
    private List<ExtensionPopupMenuItem> subMenuItems = null;
    private boolean visibleItself;

    public PopupContextMenuItemHolder(String label, String parentName) {
        super(label);
        this.parentName = parentName;
        this.visibleItself = true;
    }

    public PopupContextMenuItemHolder(String parentName) {
        super("ContextMenuItemHolder");
        this.parentName = parentName;
        this.visibleItself = false;
    }

    @Override
    public String getParentMenuName() {
        return this.parentName;
    }

    @Override
    public int getParentMenuIndex() {
        return 0;
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    private List<ExtensionPopupMenuItem> getSubmenuItems() {
        if (this.subMenuItems == null) {
            this.subMenuItems = new ArrayList<ExtensionPopupMenuItem>();
        }
        return this.subMenuItems;
    }

    @Override
    public boolean isEnableForMessageContainer(MessageContainer<?> invoker) {
        this.resetMenu();
        if (this.visibleItself) {
            return super.isEnableForMessageContainer(invoker);
        }
        return false;
    }

    private void resetMenu() {
        Vector<JMenuItem> mainPopupMenuItems = View.getSingleton().getPopupList();
        if (this.visibleItself) {
            this.removeAll();
        } else {
            for (ExtensionPopupMenuItem menu : this.getSubmenuItems()) {
                mainPopupMenuItems.remove(menu);
            }
            this.subMenuItems.clear();
        }
        Session session = Model.getSingleton().getSession();
        List<Context> contexts = session.getContexts();
        for (Context context : contexts) {
            ExtensionPopupMenuItem piicm;
            if (this.visibleItself) {
                piicm = this.getPopupContextMenu(context, this.getText());
                this.add(piicm);
                continue;
            }
            piicm = this.getPopupContextMenu(context, this.parentName);
            piicm.setMenuIndex(this.getMenuIndex());
            mainPopupMenuItems.add(piicm);
            this.subMenuItems.add(piicm);
        }
    }

    public abstract ExtensionPopupMenuItem getPopupContextMenu(Context var1, String var2);
}

