/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.stdmenus;

import com.stackhawk.hste.model.Target;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.SiteNode;

public class PopupContextTreeMenu
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private List<Integer> contextIds = new ArrayList<Integer>();
    private boolean enabledForMultipleContexts;

    public PopupContextTreeMenu() {
        this(true);
    }

    public PopupContextTreeMenu(boolean isEnabledForMultipleContexts) {
        this.enabledForMultipleContexts = isEnabledForMultipleContexts;
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        if (invoker instanceof JTree && "ContextTree".equals(invoker.getName())) {
            SiteNode node;
            JTree contextTree = (JTree)invoker;
            if (!this.isEnabledForMultipleContexts()) {
                if (contextTree.getSelectionCount() < 2) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                    return this.isEnabledForContext(this.getContextId());
                }
            }
            if ((node = (SiteNode)contextTree.getLastSelectedPathComponent()) == null || node.isRoot()) {
                return false;
            }
            this.contextIds.clear();
            TreePath[] paths = contextTree.getSelectionPaths();
            if (paths == null || paths.length == 0) {
                return false;
            }
            SiteNode[] nodes = (SiteNode[])Arrays.stream(paths).map(p -> (SiteNode)p.getLastPathComponent()).toArray(SiteNode[]::new);
            if (nodes.length == 1 && nodes[0].isRoot()) {
                return false;
            }
            Stream<Target> targets = Arrays.stream(nodes).map(n -> (Target)n.getUserObject());
            this.contextIds.addAll(Arrays.asList((Integer[])targets.map(t -> t.getContext().getId()).toArray(Integer[]::new)));
            return this.isEnabledForContext(this.getContextId());
        }
        return false;
    }

    public boolean isEnabledForContext(int contextId) {
        return true;
    }

    protected boolean isEnabledForMultipleContexts() {
        return this.enabledForMultipleContexts;
    }

    protected int getContextId() {
        return this.contextIds.isEmpty() ? -1 : this.contextIds.get(this.contextIds.size() - 1);
    }

    protected List<Integer> getContextIds() {
        return this.contextIds;
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

