/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.stdmenus;

import com.stackhawk.hste.utils.DesktopUtils;
import com.stackhawk.hste.view.messagecontainer.http.HttpMessageContainer;
import com.stackhawk.hste.view.popup.PopupMenuItemHttpMessageContainer;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;

public class PopupMenuOpenUrlInBrowser
extends PopupMenuItemHttpMessageContainer {
    private static final long serialVersionUID = 1L;
    private boolean disabledToolTipSet = false;

    public PopupMenuOpenUrlInBrowser(String label) {
        super(label);
    }

    @Override
    public void performAction(HttpMessage msg) {
        if (!DesktopUtils.openUrlInBrowser(msg.getRequestHeader().getURI())) {
            View.getSingleton().showWarningDialog(Constant.messages.getString("history.browser.warning"));
        }
    }

    @Override
    protected boolean isButtonEnabledForSelectedMessages(List<HttpMessage> httpMessages) {
        if (Constant.isInContainer() && !Model.getSingleton().getOptionsParam().getViewParam().isAllowAppIntegrationInContainers()) {
            if (!this.disabledToolTipSet) {
                this.setToolTipText(Constant.messages.getString("history.browser.disabled"));
                this.disabledToolTipSet = true;
            }
            return false;
        }
        if (this.disabledToolTipSet) {
            this.setToolTipText("");
            this.disabledToolTipSet = false;
        }
        return super.isButtonEnabledForSelectedMessages(httpMessages);
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return DesktopUtils.canOpenUrlInBrowser();
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

