/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.stdmenus;

import com.stackhawk.hste.extension.stdmenus.PopupUserMenu;
import com.stackhawk.hste.extension.users.ContextUserAuthManager;
import com.stackhawk.hste.extension.users.ExtensionUserManagement;
import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.users.User;
import com.stackhawk.hste.view.messagecontainer.MessageContainer;
import com.stackhawk.hste.view.popup.ExtensionPopupMenuMessageContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.apache.logging.log4j.LogManager;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;

public abstract class PopupUserMenuItemHolder
extends ExtensionPopupMenuMessageContainer {
    private static final long serialVersionUID = 4454384312614225721L;
    private String parentName;
    private List<ExtensionPopupMenuItem> subMenuItems = null;
    private boolean visibleItself;
    private ExtensionUserManagement extensionUserAuth;

    public PopupUserMenuItemHolder(String label, String parentName) {
        super(label);
        this.parentName = parentName;
        this.visibleItself = true;
        this.extensionUserAuth = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
        if (this.extensionUserAuth == null || !this.extensionUserAuth.isEnabled()) {
            LogManager.getLogger(PopupUserMenuItemHolder.class).warn("{} is not enabled but is required for getting info about Users.", ExtensionUserManagement.class);
            this.extensionUserAuth = null;
        }
    }

    public PopupUserMenuItemHolder(String parentName) {
        super("UserMenuItemHolder");
        this.parentName = parentName;
        this.visibleItself = false;
    }

    @Override
    public String getParentMenuName() {
        return this.parentName;
    }

    @Override
    public int getParentMenuIndex() {
        return 0;
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    private List<ExtensionPopupMenuItem> getSubmenuItems() {
        if (this.subMenuItems == null) {
            this.subMenuItems = new ArrayList<ExtensionPopupMenuItem>();
        }
        return this.subMenuItems;
    }

    @Override
    public boolean isEnableForMessageContainer(MessageContainer<?> invoker) {
        this.resetMenu();
        if (this.extensionUserAuth == null) {
            return false;
        }
        if (this.visibleItself) {
            return super.isEnableForMessageContainer(invoker);
        }
        return false;
    }

    private void resetMenu() {
        Vector<JMenuItem> mainPopupMenuItems = View.getSingleton().getPopupList();
        if (this.visibleItself) {
            this.removeAll();
        } else {
            for (ExtensionPopupMenuItem menu : this.getSubmenuItems()) {
                mainPopupMenuItems.remove(menu);
            }
            this.subMenuItems.clear();
        }
        Session session = Model.getSingleton().getSession();
        List<Context> contexts = session.getContexts();
        for (Context context : contexts) {
            ContextUserAuthManager manager = this.extensionUserAuth.getContextUserAuthManager(context.getId());
            for (User user : manager.getUsers()) {
                PopupUserMenu piicm;
                if (this.visibleItself) {
                    piicm = this.getPopupUserMenu(context, user, this.getText());
                    this.add(piicm);
                    continue;
                }
                piicm = this.getPopupUserMenu(context, user, this.parentName);
                piicm.setMenuIndex(this.getMenuIndex());
                mainPopupMenuItems.add(piicm);
                this.subMenuItems.add(piicm);
            }
        }
    }

    public abstract PopupUserMenu getPopupUserMenu(Context var1, User var2, String var3);
}

