/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.users;

import com.stackhawk.hste.authentication.AuthenticationMethodType;
import com.stackhawk.hste.extension.api.API;
import com.stackhawk.hste.extension.api.ApiAction;
import com.stackhawk.hste.extension.api.ApiDynamicActionImplementor;
import com.stackhawk.hste.extension.api.ApiException;
import com.stackhawk.hste.extension.api.ApiImplementor;
import com.stackhawk.hste.extension.api.ApiResponse;
import com.stackhawk.hste.extension.api.ApiResponseConversionUtils;
import com.stackhawk.hste.extension.api.ApiResponseElement;
import com.stackhawk.hste.extension.api.ApiResponseList;
import com.stackhawk.hste.extension.api.ApiResponseSet;
import com.stackhawk.hste.extension.api.ApiView;
import com.stackhawk.hste.extension.authentication.ExtensionAuthentication;
import com.stackhawk.hste.extension.users.ExtensionUserManagement;
import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.session.WebSession;
import com.stackhawk.hste.users.AuthenticationState;
import com.stackhawk.hste.users.User;
import com.stackhawk.hste.utils.ApiUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;

public class UsersAPI
extends ApiImplementor {
    private static final Logger LOGGER = LogManager.getLogger(UsersAPI.class);
    private static final String PREFIX = "users";
    private static final String VIEW_USERS_LIST = "usersList";
    private static final String VIEW_GET_USER_BY_ID = "getUserById";
    private static final String VIEW_GET_AUTH_CREDENTIALS = "getAuthenticationCredentials";
    private static final String VIEW_GET_AUTH_CREDENTIALS_CONFIG_PARAMETERS = "getAuthenticationCredentialsConfigParams";
    private static final String VIEW_GET_AUTH_STATE = "getAuthenticationState";
    private static final String VIEW_GET_AUTH_SESSION = "getAuthenticationSession";
    private static final String ACTION_NEW_USER = "newUser";
    private static final String ACTION_REMOVE_USER = "removeUser";
    private static final String ACTION_SET_ENABLED = "setUserEnabled";
    private static final String ACTION_SET_NAME = "setUserName";
    private static final String ACTION_SET_AUTH_CREDENTIALS = "setAuthenticationCredentials";
    private static final String ACTION_AUTHENTICATE_AS_USER = "authenticateAsUser";
    private static final String ACTION_POLL_AS_USER = "pollAsUser";
    private static final String ACTION_SET_AUTH_STATE = "setAuthenticationState";
    private static final String ACTION_SET_COOKIE = "setCookie";
    public static final String PARAM_CONTEXT_ID = "contextId";
    public static final String PARAM_USER_ID = "userId";
    private static final String PARAM_COOKIE_NAME = "name";
    private static final String PARAM_COOKIE_VALUE = "value";
    private static final String PARAM_COOKIE_DOMAIN = "domain";
    private static final String PARAM_COOKIE_PATH = "path";
    private static final String PARAM_COOKIE_SECURE = "secure";
    private static final String PARAM_USER_NAME = "name";
    private static final String PARAM_ENABLED = "enabled";
    private static final String PARAM_CREDENTIALS_CONFIG_PARAMS = "authCredentialsConfigParams";
    private static final String PARAM_LAST_POLL_RESULT = "lastPollResult";
    private static final String PARAM_LAST_POLL_TIME_IN_MS = "lastPollTimeInMs";
    private static final String PARAM_REQUESTS_SINCE_LAST_POLL = "requestsSinceLastPoll";
    private static final String TIME_NOW = "NOW";
    private ExtensionUserManagement extension;
    private Map<Integer, ApiDynamicActionImplementor> loadedAuthenticationMethodActions;

    public UsersAPI(ExtensionUserManagement extension) {
        this.extension = extension;
        this.addApiView(new ApiView(VIEW_USERS_LIST, null, new String[]{PARAM_CONTEXT_ID}));
        this.addApiView(new ApiView(VIEW_GET_USER_BY_ID, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiView(new ApiView(VIEW_GET_AUTH_CREDENTIALS_CONFIG_PARAMETERS, new String[]{PARAM_CONTEXT_ID}));
        this.addApiView(new ApiView(VIEW_GET_AUTH_CREDENTIALS, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiView(new ApiView(VIEW_GET_AUTH_STATE, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiView(new ApiView(VIEW_GET_AUTH_SESSION, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiAction(new ApiAction(ACTION_NEW_USER, new String[]{PARAM_CONTEXT_ID, "name"}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_USER, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiAction(new ApiAction(ACTION_SET_ENABLED, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID, PARAM_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_SET_NAME, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID, "name"}));
        this.addApiAction(new ApiAction(ACTION_SET_AUTH_CREDENTIALS, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}, new String[]{PARAM_CREDENTIALS_CONFIG_PARAMS}));
        this.addApiAction(new ApiAction(ACTION_AUTHENTICATE_AS_USER, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiAction(new ApiAction(ACTION_POLL_AS_USER, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiAction(new ApiAction(ACTION_SET_AUTH_STATE, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}, new String[]{PARAM_LAST_POLL_RESULT, PARAM_LAST_POLL_TIME_IN_MS, PARAM_REQUESTS_SINCE_LAST_POLL}));
        this.addApiAction(new ApiAction(ACTION_SET_COOKIE, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID, PARAM_COOKIE_DOMAIN, "name", PARAM_COOKIE_VALUE}, new String[]{PARAM_COOKIE_PATH, PARAM_COOKIE_SECURE}));
        if (Control.getSingleton() != null) {
            ExtensionAuthentication authenticationExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAuthentication.class);
            this.loadedAuthenticationMethodActions = new HashMap<Integer, ApiDynamicActionImplementor>();
            if (authenticationExtension != null) {
                for (AuthenticationMethodType t : authenticationExtension.getAuthenticationMethodTypes()) {
                    ApiDynamicActionImplementor i = t.getSetCredentialsForUserApiAction();
                    if (i == null) continue;
                    this.loadedAuthenticationMethodActions.put(t.getUniqueIdentifier(), i);
                }
            }
        }
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        LOGGER.debug("handleApiView {} {}", (Object)name, (Object)params);
        switch (name) {
            case "usersList": {
                List<Object> users;
                ApiResponseList usersListResponse = new ApiResponseList(name);
                if (this.hasContextId(params)) {
                    users = this.extension.getContextUserAuthManager(this.getContextId(params)).getUsers();
                } else {
                    users = new ArrayList();
                    for (Context context : Model.getSingleton().getSession().getContexts()) {
                        users.addAll(this.extension.getContextUserAuthManager(context.getId()).getUsers());
                    }
                }
                for (User user : users) {
                    usersListResponse.addItem(this.buildResponseFromUser(user));
                }
                return usersListResponse;
            }
            case "getUserById": {
                return this.buildResponseFromUser(this.getUser(params));
            }
            case "getAuthenticationCredentials": {
                return this.getUser(params).getAuthenticationCredentials().getApiResponseRepresentation();
            }
            case "getAuthenticationCredentialsConfigParams": {
                AuthenticationMethodType type = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID).getAuthenticationMethod().getType();
                ApiDynamicActionImplementor apiDynamicActionImplementor = this.loadedAuthenticationMethodActions.get(type.getUniqueIdentifier());
                return apiDynamicActionImplementor.buildParamsDescription();
            }
            case "getAuthenticationState": {
                return this.buildResponseFromAuthState(this.getUser(params).getAuthenticationState());
            }
            case "getAuthenticationSession": {
                return this.buildResponseFromAuthSession(this.getUser(params).getAuthenticatedSession());
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        LOGGER.debug("handleApiAction {} {}", (Object)name, (Object)params);
        switch (name) {
            case "newUser": {
                Context context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                String userName = ApiUtils.getNonEmptyStringParam(params, "name");
                User user = new User(context.getId(), userName);
                user.setAuthenticationCredentials(context.getAuthenticationMethod().createAuthenticationCredentials());
                this.extension.getContextUserAuthManager(context.getId()).addUser(user);
                context.save();
                return new ApiResponseElement(PARAM_USER_ID, String.valueOf(user.getId()));
            }
            case "removeUser": {
                Context context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                int userId = ApiUtils.getIntParam(params, PARAM_USER_ID);
                boolean deleted = this.extension.getContextUserAuthManager(context.getId()).removeUserById(userId);
                if (deleted) {
                    context.save();
                    return ApiResponseElement.OK;
                }
                return ApiResponseElement.FAIL;
            }
            case "setUserEnabled": {
                boolean enabled = false;
                try {
                    enabled = params.getBoolean(PARAM_ENABLED);
                }
                catch (JSONException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "enabled - should be boolean");
                }
                User user = this.getUser(params);
                user.setEnabled(enabled);
                user.getContext().save();
                return ApiResponseElement.OK;
            }
            case "setUserName": {
                String nameSN = params.getString("name");
                if (nameSN == null || nameSN.isEmpty()) {
                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, "name");
                }
                User user = this.getUser(params);
                user.setName(nameSN);
                user.getContext().save();
                return ApiResponseElement.OK;
            }
            case "setAuthenticationCredentials": {
                JSONObject actionParams = params.has(PARAM_CREDENTIALS_CONFIG_PARAMS) ? API.getParams(params.getString(PARAM_CREDENTIALS_CONFIG_PARAMS)) : new JSONObject();
                Context context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                actionParams.put((Object)PARAM_CONTEXT_ID, (Object)context.getId());
                actionParams.put((Object)PARAM_USER_ID, (Object)this.getUserId(params));
                ApiDynamicActionImplementor a = this.loadedAuthenticationMethodActions.get(context.getAuthenticationMethod().getType().getUniqueIdentifier());
                a.handleAction(actionParams);
                context.save();
                return ApiResponseElement.OK;
            }
            case "authenticateAsUser": {
                ExtensionHistory extHistory;
                User user = this.getUser(params);
                int hId1 = user.getAuthenticationState().getLastAuthRequestHistoryId();
                user.authenticate();
                int hId2 = user.getAuthenticationState().getLastAuthRequestHistoryId();
                if (hId2 > hId1 && (extHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class)) != null) {
                    HistoryReference href = extHistory.getHistoryReference(hId2);
                    try {
                        HttpMessage authMsg = href.getHttpMessage();
                        ApiResponseSet<String> responseSet = ApiResponseConversionUtils.httpMessageToSet(hId2, authMsg);
                        responseSet.put("authSuccessful", Boolean.toString(user.getContext().getAuthenticationMethod().evaluateAuthRequest(authMsg, user.getAuthenticationState())));
                        return responseSet;
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to read auth request from db {}", (Object)hId2, (Object)e);
                        throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
                    }
                }
                return ApiResponseElement.OK;
            }
            case "pollAsUser": {
                User user = this.getUser(params);
                try {
                    HttpMessage msg = user.getContext().getAuthenticationMethod().pollAsUser(user);
                    int href = -1;
                    if (msg.getHistoryRef() != null) {
                        href = msg.getHistoryRef().getHistoryId();
                    }
                    ApiResponseSet<String> responseSet = ApiResponseConversionUtils.httpMessageToSet(href, msg);
                    responseSet.put("pollSuccessful", Boolean.toString(user.getContext().getAuthenticationMethod().evaluateAuthRequest(msg, user.getAuthenticationState())));
                    return responseSet;
                }
                catch (IllegalArgumentException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_CONTEXT_ID);
                }
                catch (IOException e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
                }
            }
            case "setAuthenticationState": {
                int reqsSinceLastPoll;
                String lastPollTimeStr;
                User user = this.getUser(params);
                AuthenticationState state = user.getAuthenticationState();
                String lastPollResultStr = this.getParam(params, PARAM_LAST_POLL_RESULT, "");
                if (StringUtils.isNotBlank((CharSequence)lastPollResultStr)) {
                    try {
                        state.setLastPollResult(Boolean.parseBoolean(lastPollResultStr));
                    }
                    catch (Exception e) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_LAST_POLL_RESULT);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(lastPollTimeStr = this.getParam(params, PARAM_LAST_POLL_TIME_IN_MS, "")))) {
                    try {
                        long lastPollTime = lastPollTimeStr.equals(TIME_NOW) ? System.currentTimeMillis() : Long.parseLong(lastPollTimeStr);
                        state.setLastPollTime(lastPollTime);
                    }
                    catch (Exception e) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_LAST_POLL_TIME_IN_MS);
                    }
                }
                if ((reqsSinceLastPoll = this.getParam(params, PARAM_REQUESTS_SINCE_LAST_POLL, -1)) >= 0) {
                    state.setRequestsSincePoll(reqsSinceLastPoll);
                }
                return ApiResponseElement.OK;
            }
            case "setCookie": {
                String cookiePath;
                User user = this.getUser(params);
                if (user.getAuthenticatedSession() == null) {
                    user.setAuthenticatedSession(user.getContext().getSessionManagementMethod().createEmptyWebSession());
                }
                if ((cookiePath = this.getParam(params, PARAM_COOKIE_PATH, "")).isEmpty()) {
                    cookiePath = null;
                }
                user.getAuthenticatedSession().getHttpState().addCookie(new Cookie(params.getString(PARAM_COOKIE_DOMAIN), params.getString("name"), params.getString(PARAM_COOKIE_VALUE), cookiePath, null, this.getParam(params, PARAM_COOKIE_SECURE, false)));
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    private ApiResponse buildResponseFromUser(User u) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("name", u.getName());
        fields.put("id", Integer.toString(u.getId()));
        fields.put(PARAM_CONTEXT_ID, Integer.toString(u.getContextId()));
        fields.put(PARAM_ENABLED, Boolean.toString(u.isEnabled()));
        fields.put("credentials", u.getAuthenticationCredentials().getApiResponseRepresentation().toJSON().toString());
        return new ApiResponseSet("user", fields);
    }

    private ApiResponse buildResponseFromAuthState(AuthenticationState state) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("lastSuccessfulAuthTimeInMs", Long.toString(state.getLastSuccessfulAuthTime()));
        fields.put("lastAuthFailure", state.getLastAuthFailure());
        fields.put("lastAuthHistoryId", Integer.toString(state.getLastAuthRequestHistoryId()));
        fields.put(PARAM_LAST_POLL_RESULT, String.valueOf(state.getLastPollResult()));
        fields.put(PARAM_REQUESTS_SINCE_LAST_POLL, Integer.toString(state.getRequestsSincePoll()));
        fields.put(PARAM_LAST_POLL_TIME_IN_MS, Long.toString(state.getLastPollTime()));
        return new ApiResponseSet("authenticationState", fields);
    }

    private ApiResponse buildResponseFromAuthSession(WebSession session) {
        ApiResponseList list = new ApiResponseList("authenticationSession");
        if (session == null) {
            return list;
        }
        HttpState state = session.getHttpState();
        ApiResponseList cookieList = new ApiResponseList("cookies");
        for (Cookie cookie : state.getCookies()) {
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put(PARAM_COOKIE_DOMAIN, cookie.getDomain());
            fields.put("name", cookie.getName());
            fields.put(PARAM_COOKIE_VALUE, cookie.getValue());
            fields.put(PARAM_COOKIE_PATH, cookie.getPath());
            fields.put("expires", String.valueOf(cookie.getExpiryDate()));
            fields.put(PARAM_COOKIE_SECURE, Boolean.toString(cookie.getSecure()));
            fields.put("comment", cookie.getComment());
            cookieList.addItem(new ApiResponseSet("cookie", fields));
        }
        list.addItem(cookieList);
        try {
            HashMap credMap = new HashMap();
            Field credMapField = state.getClass().getDeclaredField("credMap");
            credMapField.setAccessible(true);
            Object obj = credMapField.get(state);
            if (obj instanceof HashMap) {
                ((HashMap)obj).forEach((k, v) -> credMap.put(k.toString(), v.toString()));
            }
            ApiResponseList credList = new ApiResponseList("credentials");
            credList.addItem(new ApiResponseSet("credentials", credMap));
            list.addItem(credList);
        }
        catch (Exception e) {
            LOGGER.error("Failed to access HttpState credMap", (Throwable)e);
        }
        return list;
    }

    private int getUserId(JSONObject params) throws ApiException {
        return ApiUtils.getIntParam(params, PARAM_USER_ID);
    }

    private User getUser(JSONObject params) throws ApiException {
        int contextId = this.getContextId(params);
        int userId = this.getUserId(params);
        User user = this.extension.getContextUserAuthManager(contextId).getUserById(userId);
        if (user == null) {
            throw new ApiException(ApiException.Type.USER_NOT_FOUND, PARAM_USER_ID);
        }
        return user;
    }

    private int getContextId(JSONObject params) throws ApiException {
        return ApiUtils.getIntParam(params, PARAM_CONTEXT_ID);
    }

    private boolean hasContextId(JSONObject params) {
        try {
            params.getInt(PARAM_CONTEXT_ID);
        }
        catch (JSONException ex) {
            return false;
        }
        return true;
    }
}

