/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.model;

import com.stackhawk.hste.HSTE;
import com.stackhawk.hste.eventBus.Event;
import com.stackhawk.hste.eventBus.EventPublisher;
import com.stackhawk.hste.model.Target;
import com.stackhawk.hste.users.User;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class ScanEventPublisher
implements EventPublisher {
    public static final String SCAN_STARTED_EVENT = "scan.started";
    public static final String SCAN_STOPPED_EVENT = "scan.stopped";
    public static final String SCAN_PAUSED_EVENT = "scan.paused";
    public static final String SCAN_RESUMED_EVENT = "scan.resumed";
    public static final String SCAN_COMPLETED_EVENT = "scan.completed";
    public static final String SCAN_PROGRESS_EVENT = "scan.progress";
    public static final String SCAN_ID = "scanId";
    public static final String SCAN_PROGRESS = "scanProgress";
    public static final String TARGET_URL = "url";
    public static final String USER_ID = "userId";
    public static final String USER_NAME = "userName";
    private static final String[] EVENTS = new String[]{"scan.started", "scan.stopped", "scan.paused", "scan.resumed", "scan.completed", "scan.progress"};

    protected static String[] getEvents() {
        return Arrays.copyOf(EVENTS, EVENTS.length);
    }

    @Override
    public String getPublisherName() {
        return ScanEventPublisher.class.getCanonicalName();
    }

    public void publishScanEvent(EventPublisher publisher, String event, int scanId) {
        this.publishScanEvent(publisher, event, scanId, (Target)null, null);
    }

    public void publishScanEvent(EventPublisher publisher, String event, int scanId, Target target, User user) {
        this.publishScanEvent(publisher, event, scanId, target, user, new HashMap<String, String>());
    }

    public void publishScanEvent(EventPublisher publisher, String event, int scanId, String url, User user) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (url != null) {
            map.put(TARGET_URL, url);
        }
        this.publishScanEvent(publisher, event, scanId, null, user, map);
    }

    public void publishScanEvent(EventPublisher publisher, String event, int scanId, Target target, User user, Map<String, String> params) {
        params.put(SCAN_ID, Integer.toString(scanId));
        if (user != null) {
            params.put(USER_ID, Integer.toString(user.getId()));
            params.put(USER_NAME, user.getName());
        }
        HSTE.getEventBus().publishSyncEvent(publisher, new Event(publisher, event, target, params));
    }

    public void publishScanProgressEvent(EventPublisher publisher, int scanId, int scanProgress) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SCAN_ID, Integer.toString(scanId));
        map.put(SCAN_PROGRESS, Integer.toString(scanProgress));
        HSTE.getEventBus().publishSyncEvent(publisher, new Event(publisher, SCAN_PROGRESS_EVENT, null, map));
    }
}

