/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.model;

import com.stackhawk.hste.model.DefaultNameValuePair;
import com.stackhawk.hste.model.NameValuePair;
import com.stackhawk.hste.model.StructuralNode;
import com.stackhawk.hste.model.StructuralSiteNode;
import com.stackhawk.hste.model.StructuralTableNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordStructure;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class SessionStructure {
    public static final String ROOT = "Root";
    public static final String DATA_DRIVEN_NODE_PREFIX = "\u00ab";
    public static final String DATA_DRIVEN_NODE_POSTFIX = "\u00bb";
    public static final String DATA_DRIVEN_NODE_REGEX = "(.+?)";
    private static final String MULTIPART_FORM_DATA_DISPLAY = "(multipart/form-data)";
    private static final Logger LOGGER = LogManager.getLogger(SessionStructure.class);

    @Deprecated
    public static StructuralNode addPath(Session session, HistoryReference ref, HttpMessage msg) {
        return SessionStructure.addPath(session, ref, msg, false);
    }

    public static StructuralNode addPath(Model model, HistoryReference ref, HttpMessage msg) {
        return SessionStructure.addPath(model, ref, msg, false);
    }

    @Deprecated
    public static StructuralNode addPath(Session session, HistoryReference ref, HttpMessage msg, boolean newOnly) {
        return SessionStructure.addPath(Model.getSingleton(), ref, msg, newOnly);
    }

    public static StructuralNode addPath(Model model, HistoryReference ref, HttpMessage msg, boolean newOnly) {
        Session session = model.getSession();
        if (!Constant.isLowMemoryOptionSet()) {
            SiteNode node = session.getSiteTree().addPath(ref, msg, newOnly);
            if (node != null) {
                return new StructuralSiteNode(node);
            }
            return null;
        }
        try {
            List<String> paths = SessionStructure.getTreePath(model, msg);
            String host = SessionStructure.getHostName(msg.getRequestHeader().getURI());
            RecordStructure rs = SessionStructure.addStructure(model, host, msg, paths, paths.size(), ref.getHistoryId(), newOnly);
            if (rs != null) {
                return new StructuralTableNode(rs);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<String> getTreePath(Model model, URI uri) throws URIException {
        return model.getSession().getUrlParamParser(uri.toString()).getTreePath(uri);
    }

    public static List<String> getTreePath(Model model, HttpMessage msg) throws URIException {
        for (Variant variant : model.getVariantFactory().createSiteModifyingVariants()) {
            try {
                List<String> path = variant.getTreePath(msg);
                if (path == null) continue;
                return path;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        URI uri = msg.getRequestHeader().getURI();
        return model.getSession().getUrlParamParser(uri.toString()).getTreePath(msg);
    }

    public static StructuralNode find(Model model, HttpMessage msg) throws DatabaseException, URIException {
        if (!Constant.isLowMemoryOptionSet()) {
            SiteNode node = model.getSession().getSiteTree().findNode(msg);
            if (node == null) {
                return null;
            }
            return new StructuralSiteNode(node);
        }
        String nodeName = SessionStructure.getNodeName(model, msg);
        RecordStructure rs = model.getDb().getTableStructure().find(model.getSession().getSessionId(), nodeName, msg.getRequestHeader().getMethod());
        if (rs == null) {
            return null;
        }
        return new StructuralTableNode(rs);
    }

    @Deprecated
    public static StructuralNode find(long sessionId, URI uri, String method, String postData) throws DatabaseException, URIException {
        Model model = Model.getSingleton();
        if (!Constant.isLowMemoryOptionSet()) {
            SiteNode node = model.getSession().getSiteTree().findNode(uri, method, postData);
            if (node == null) {
                return null;
            }
            return new StructuralSiteNode(node);
        }
        String nodeName = SessionStructure.getNodeName(model, uri, method, postData, null);
        RecordStructure rs = model.getDb().getTableStructure().find(sessionId, nodeName, method);
        if (rs == null) {
            return null;
        }
        return new StructuralTableNode(rs);
    }

    public static StructuralNode find(Model model, URI uri, String method, String postData) throws DatabaseException, URIException {
        Session session = model.getSession();
        if (!Constant.isLowMemoryOptionSet()) {
            SiteNode node = session.getSiteTree().findNode(uri, method, postData);
            if (node == null) {
                return null;
            }
            return new StructuralSiteNode(node);
        }
        String nodeName = SessionStructure.getNodeName(model, uri, method, postData, null);
        RecordStructure rs = model.getDb().getTableStructure().find(session.getSessionId(), nodeName, method);
        if (rs == null) {
            return null;
        }
        return new StructuralTableNode(rs);
    }

    private static String getNodeName(Model model, URI uri, String method, String postData, String contentType) throws URIException {
        Session session = model.getSession();
        List<String> paths = SessionStructure.getTreePath(model, uri);
        String host = SessionStructure.getHostName(uri);
        Object nodeUrl = SessionStructure.pathsToUrl(host, paths, paths.size());
        String params = SessionStructure.getParams(session, uri, postData, contentType);
        if (params.length() > 0) {
            nodeUrl = (String)nodeUrl + " " + params;
        }
        return nodeUrl;
    }

    private static String getNodeName(Session session, String host, HttpMessage msg, List<String> paths, int size) throws URIException {
        String params;
        Object nodeUrl = SessionStructure.pathsToUrl(host, paths, size);
        if (msg != null && (params = SessionStructure.getParams(session, msg)).length() > 0) {
            nodeUrl = (String)nodeUrl + " " + params;
        }
        return nodeUrl;
    }

    @Deprecated
    public static String getNodeName(HttpMessage msg) throws URIException {
        return SessionStructure.getNodeName(Model.getSingleton(), msg);
    }

    public static String getNodeName(Model model, HttpMessage msg) throws URIException {
        return SessionStructure.getNodeName(model, msg.getRequestHeader().getURI(), msg.getRequestHeader().getMethod(), msg.getRequestBody().toString(), msg.getRequestHeader().getHeader("content-type"));
    }

    public static String getLeafName(Model model, String nodeName, HttpMessage msg) {
        for (Variant variant : model.getVariantFactory().createSiteModifyingVariants()) {
            try {
                String name = variant.getLeafName(nodeName, msg);
                if (name == null) continue;
                return name;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        List<org.parosproxy.paros.core.scanner.NameValuePair> params = SessionStructure.convertNVP(model.getSession().getParameters(msg, HtmlParameter.Type.url), 1);
        if (msg.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            params.addAll(SessionStructure.convertNVP(model.getSession().getParameters(msg, HtmlParameter.Type.form), 2));
        }
        return SessionStructure.getLeafName(nodeName, msg, params);
    }

    public static String getLeafName(Model model, String nodeName, URI uri, String method, String postData) throws HttpMalformedHeaderException {
        Objects.requireNonNull(uri);
        Objects.requireNonNull(method);
        HttpMessage msg = new HttpMessage(uri);
        msg.getRequestHeader().setMethod(method);
        if (method.equalsIgnoreCase("POST")) {
            msg.getRequestBody().setBody(postData);
            msg.getRequestHeader().setContentLength(msg.getRequestBody().length());
        }
        return SessionStructure.getLeafName(model, nodeName, msg);
    }

    public static String getLeafName(String nodeName, HttpMessage message, List<org.parosproxy.paros.core.scanner.NameValuePair> params) {
        String method = message.getRequestHeader().getMethod();
        StringBuilder sb = new StringBuilder();
        sb.append(method);
        sb.append(":");
        sb.append(nodeName);
        if (method.equalsIgnoreCase("POST")) {
            sb.append(SessionStructure.getQueryParamString(SessionStructure.convertParosNVP(params, 1), true));
            String contentType = message.getRequestHeader().getHeader("content-type");
            if (contentType != null && contentType.startsWith("multipart/form-data")) {
                sb.append(MULTIPART_FORM_DATA_DISPLAY);
            } else {
                sb.append(SessionStructure.getQueryParamString(SessionStructure.convertParosNVP(params, 2), false));
            }
        } else {
            sb.append(SessionStructure.getQueryParamString(SessionStructure.convertParosNVP(params, 1), false));
            sb.append(SessionStructure.getQueryParamString(SessionStructure.convertParosNVP(params, 2), false));
        }
        return sb.toString();
    }

    private static List<org.parosproxy.paros.core.scanner.NameValuePair> convertNVP(List<NameValuePair> nvpList, int type) {
        ArrayList<org.parosproxy.paros.core.scanner.NameValuePair> params = new ArrayList<org.parosproxy.paros.core.scanner.NameValuePair>();
        for (NameValuePair nvp : nvpList) {
            params.add(new org.parosproxy.paros.core.scanner.NameValuePair(type, nvp.getName(), nvp.getValue(), -1));
        }
        return params;
    }

    private static List<NameValuePair> convertParosNVP(List<org.parosproxy.paros.core.scanner.NameValuePair> nvpList, int type) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (org.parosproxy.paros.core.scanner.NameValuePair nvp : nvpList) {
            if (nvp.getType() != type) continue;
            params.add(new DefaultNameValuePair(nvp.getName(), nvp.getValue()));
        }
        return params;
    }

    public static String regexEscape(String str) {
        String chrsToEscape = ".*+?^=!${}()|[]\\";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (chrsToEscape.indexOf(c) >= 0) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getRegexName(StructuralNode sn, boolean incParams) {
        return SessionStructure.getSpecifiedName(sn, incParams, true);
    }

    public static String getCleanRelativeName(StructuralNode sn, boolean incParams) {
        return SessionStructure.getSpecifiedName(sn, incParams, false);
    }

    private static String getSpecifiedName(StructuralNode sn, boolean incParams, boolean dataDrivenNodesAsRegex) {
        int colonIndex;
        int queryIndex;
        Object name = sn.getName();
        if (sn.isDataDriven() && dataDrivenNodesAsRegex) {
            return DATA_DRIVEN_NODE_REGEX;
        }
        int bracketIndex = ((String)name).lastIndexOf("(");
        if (bracketIndex >= 0) {
            name = ((String)name).substring(0, bracketIndex);
        }
        if ((queryIndex = ((String)name).indexOf("?")) >= 0) {
            if (incParams) {
                String params = ((String)name).substring(queryIndex);
                name = ((String)name).substring(0, queryIndex) + SessionStructure.regexEscape(params);
            } else {
                name = ((String)name).substring(0, queryIndex);
            }
        }
        try {
            if (sn.getURI().getPath() == null || sn.getURI().getPath().length() == 0) {
                return name;
            }
        }
        catch (URIException params) {
            // empty catch block
        }
        int slashIndex = ((String)name).lastIndexOf(47);
        if (slashIndex >= 0) {
            name = ((String)name).substring(slashIndex + 1);
        }
        if (sn.isLeaf() && (colonIndex = ((String)name).indexOf(":")) > 0) {
            name = ((String)name).substring(colonIndex + 1);
        }
        return name;
    }

    public static String getRegexPattern(StructuralNode sn) throws DatabaseException {
        return SessionStructure.getRegexPattern(sn, true);
    }

    public static String getRegexPattern(StructuralNode sn, boolean incChildren) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        boolean incParams = sn.isLeaf() || !incChildren;
        boolean lastLeafReturned = false;
        while (!sn.isRoot()) {
            if (lastLeafReturned) {
                sb.insert(0, "/");
            }
            sb.insert(0, SessionStructure.getRegexName(sn, incParams));
            sn = sn.getParent();
            incParams = false;
            lastLeafReturned = true;
        }
        if (incChildren) {
            sb.append(".*");
        }
        return sb.toString();
    }

    private static RecordStructure addStructure(Model model, String host, HttpMessage msg, List<String> paths, int size, int historyId, boolean newOnly) throws DatabaseException, URIException {
        RecordStructure msgRs;
        Session session = model.getSession();
        Object nodeName = SessionStructure.getNodeName(session, host, msg, paths, size);
        String parentName = SessionStructure.pathsToUrl(host, paths, size - 1);
        String url = "";
        if (msg != null) {
            url = msg.getRequestHeader().getURI().toString();
            String params = SessionStructure.getParams(session, msg);
            if (params.length() > 0) {
                nodeName = (String)nodeName + " " + params;
            }
        }
        String method = "GET";
        if (msg != null) {
            method = msg.getRequestHeader().getMethod();
        }
        if ((msgRs = model.getDb().getTableStructure().find(session.getSessionId(), (String)nodeName, method)) == null) {
            long parentId = -1L;
            if (!((String)nodeName).equals(ROOT)) {
                HttpMessage tmpMsg = null;
                int parentHistoryId = -1;
                if (!parentName.equals(ROOT)) {
                    tmpMsg = SessionStructure.getTempHttpMessage(session, parentName, msg);
                    parentHistoryId = tmpMsg.getHistoryRef().getHistoryId();
                }
                RecordStructure parentRs = SessionStructure.addStructure(model, host, tmpMsg, paths, size - 1, parentHistoryId, false);
                parentId = parentRs.getStructureId();
            }
            msgRs = model.getDb().getTableStructure().insert(session.getSessionId(), parentId, historyId, (String)nodeName, url, method);
        } else if (newOnly) {
            return null;
        }
        return msgRs;
    }

    private static HttpMessage getTempHttpMessage(Session session, String url, HttpMessage base) {
        try {
            HttpMessage newMsg = base.cloneRequest();
            URI uri = new URI(url, false);
            newMsg.getRequestHeader().setURI(uri);
            newMsg.getRequestHeader().setMethod("GET");
            newMsg.getRequestBody().setBody("");
            newMsg.getRequestHeader().setHeader("content-type", null);
            newMsg.getRequestHeader().setHeader("content-length", null);
            HistoryReference historyRef = new HistoryReference(session, 0, newMsg);
            newMsg.setHistoryRef(historyRef);
            return newMsg;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String pathsToUrl(String host, List<String> paths, int size) {
        if (size < 0) {
            return ROOT;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(host);
        int i = 1;
        for (String path : paths) {
            if (i > size) break;
            if (sb.length() > 0 && !path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
            ++i;
        }
        return sb.toString();
    }

    public static String getHostName(HttpMessage msg) throws URIException {
        return SessionStructure.getHostName(msg.getRequestHeader().getURI());
    }

    public static String getHostName(URI uri) throws URIException {
        StringBuilder host = new StringBuilder();
        String scheme = SessionStructure.getScheme(uri);
        host.append(scheme).append("://").append(uri.getHost());
        int port = uri.getPort();
        if (port != -1 && (port == 80 && !"http".equals(scheme) || port == 443 && !"https".equals(scheme) || port != 80 && port != 443)) {
            host.append(":").append(port);
        }
        return host.toString();
    }

    private static String getScheme(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            return uri.getPort() == 443 ? "https" : "http";
        }
        return scheme.toLowerCase(Locale.ROOT);
    }

    @Deprecated
    public static StructuralNode getRootNode() {
        return SessionStructure.getRootNode(Model.getSingleton());
    }

    public static StructuralNode getRootNode(Model model) {
        if (!Constant.isLowMemoryOptionSet()) {
            return new StructuralSiteNode(model.getSession().getSiteTree().getRoot());
        }
        Session session = model.getSession();
        try {
            RecordStructure rs = model.getDb().getTableStructure().find(session.getSessionId(), ROOT, "GET");
            if (rs != null) {
                return new StructuralTableNode(rs);
            }
        }
        catch (DatabaseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static String getParams(Session session, HttpMessage msg) throws URIException {
        return SessionStructure.getParams(session, msg.getRequestHeader().getURI(), msg.getRequestBody().toString(), msg.getRequestHeader().getHeader("content-type"));
    }

    private static String getParams(Session session, URI uri, String requestBody, String contentType) throws URIException {
        boolean hasReqBody = contentType != null && requestBody != null && !requestBody.isEmpty();
        Object leafParams = SessionStructure.getQueryParamString(session.getUrlParameters(uri), hasReqBody);
        if (!hasReqBody) {
            return leafParams;
        }
        if (contentType.startsWith("multipart/form-data")) {
            leafParams = (String)leafParams + MULTIPART_FORM_DATA_DISPLAY;
        } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
            leafParams = (String)leafParams + SessionStructure.getQueryParamString(session.getFormParameters(uri, requestBody), false);
        }
        return leafParams;
    }

    private static String getQueryParamString(List<NameValuePair> list, boolean isUrlWithPostData) {
        StringBuilder sb = new StringBuilder();
        list.stream().sorted().forEach(entry -> {
            Object name = entry.getName();
            if (name != null) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (((String)name).length() > 40) {
                    name = ((String)name).substring(0, 40) + "...";
                }
                sb.append((String)name);
            }
        });
        String result = "";
        if (sb.length() > 0 || isUrlWithPostData) {
            result = sb.insert(0, '(').append(')').toString();
        }
        return result;
    }
}

