/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.model;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.parosproxy.paros.Constant;

public final class SessionUtils {
    public static final String SESSION_EXTENSION = ".session";

    private SessionUtils() {
    }

    public static Path getSessionPath(String session) {
        String normalisedSession = SessionUtils.getNormalisedSessionName(session);
        Path sessionPath = Paths.get(normalisedSession, new String[0]);
        if (!sessionPath.isAbsolute()) {
            sessionPath = Paths.get(Constant.getHsteHome(), "session").resolve(sessionPath);
        }
        return sessionPath;
    }

    private static String getNormalisedSessionName(String session) {
        if (!session.endsWith(SESSION_EXTENSION)) {
            return session + SESSION_EXTENSION;
        }
        return session;
    }
}

