/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.model;

import com.stackhawk.hste.model.SessionStructure;
import com.stackhawk.hste.model.StructuralNode;
import com.stackhawk.hste.model.StructuralTableNodeIterator;
import java.security.InvalidParameterException;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordStructure;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;

public class StructuralTableNode
implements StructuralNode {
    private RecordStructure rs;
    private StructuralNode parent = null;
    private static ExtensionHistory extHistory = null;

    public StructuralTableNode(RecordStructure rs) {
        if (rs == null) {
            throw new InvalidParameterException("RecordStructure must not be null");
        }
        this.rs = rs;
    }

    @Override
    public StructuralNode getParent() throws DatabaseException {
        if (this.parent == null && !this.isRoot()) {
            RecordStructure prs = Model.getSingleton().getDb().getTableStructure().read(this.rs.getSessionId(), this.rs.getStructureId());
            if (prs == null) {
                throw new InvalidParameterException("Failed to find parent sessionId=" + this.rs.getSessionId() + " parentId=" + this.rs.getParentId());
            }
            this.parent = new StructuralTableNode(prs);
        }
        return this.parent;
    }

    @Override
    public Iterator<StructuralNode> getChildIterator() {
        return new StructuralTableNodeIterator(this);
    }

    @Override
    public long getChildNodeCount() throws DatabaseException {
        return Model.getSingleton().getDb().getTableStructure().getChildCount(this.rs.getSessionId(), this.rs.getParentId());
    }

    @Override
    public HistoryReference getHistoryReference() {
        return StructuralTableNode.getExtensionHistory().getHistoryReference(this.rs.getHistoryId());
    }

    @Override
    public URI getURI() {
        try {
            return new URI(this.rs.getUrl(), true);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.rs.getName();
    }

    @Override
    public String getMethod() {
        return this.rs.getMethod();
    }

    @Override
    public boolean isRoot() {
        return "Root".equals(this.rs.getUrl());
    }

    @Override
    public boolean isLeaf() {
        try {
            return this.getChildNodeCount() == 0L;
        }
        catch (DatabaseException e) {
            return false;
        }
    }

    protected RecordStructure getRecordStructure() {
        return this.rs;
    }

    @Override
    public boolean isSameAs(StructuralNode node) {
        if (node instanceof StructuralTableNode) {
            return this.rs.getStructureId() == ((StructuralTableNode)node).rs.getStructureId();
        }
        return false;
    }

    private static ExtensionHistory getExtensionHistory() {
        if (extHistory == null) {
            extHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        }
        return extHistory;
    }

    @Override
    public String getRegexPattern() throws DatabaseException {
        return this.getRegexPattern(true);
    }

    @Override
    public String getRegexPattern(boolean incChildren) throws DatabaseException {
        return SessionStructure.getRegexPattern(this, incChildren);
    }

    @Override
    public boolean isDataDriven() {
        String name = this.getName();
        int slashIndex = name.lastIndexOf(47);
        if (slashIndex >= 0) {
            name = name.substring(slashIndex + 1);
        }
        return name.startsWith("\u00ab");
    }

    public int hashCode() {
        return Objects.hash(this.rs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StructuralTableNode)) {
            return false;
        }
        StructuralTableNode other = (StructuralTableNode)obj;
        return Objects.equals(this.rs, other.rs);
    }
}

