/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.scan;

import com.stackhawk.hste.scan.BaseScannerThread;
import com.stackhawk.hste.scan.ScanListener;
import com.stackhawk.hste.scan.ScanStartOptions;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class BaseContextScannerThread<StartOptions extends ScanStartOptions, Listener extends ScanListener>
extends BaseScannerThread<StartOptions> {
    protected Set<Listener> listeners;
    protected int contextId;

    public BaseContextScannerThread(int contextId) {
        this.contextId = contextId;
        this.listeners = new LinkedHashSet<Listener>();
    }

    public void addScanListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeScanListener(Listener l) {
        this.listeners.remove(l);
    }

    protected void notifyScanStarted() {
        for (ScanListener l : this.listeners) {
            l.scanStarted(this.contextId);
        }
    }

    protected void notifyScanFinished() {
        for (ScanListener l : this.listeners) {
            l.scanFinished(this.contextId);
        }
    }

    protected void notifyScanProgress() {
        for (ScanListener l : this.listeners) {
            l.scanProgress(this.contextId, this.getScanProgress(), this.getScanMaximumProgress());
        }
    }

    @Override
    public void setScanProgress(int progress) {
        super.setScanProgress(progress);
        this.notifyScanProgress();
    }
}

