/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.spider.filters;

import com.stackhawk.hste.spider.filters.FetchFilter;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class HttpPrefixFetchFilter
extends FetchFilter {
    private static final Logger LOGGER = LogManager.getLogger(HttpPrefixFetchFilter.class);
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final int DEFAULT_PORT = -1;
    private static final int UNKNOWN_PORT = -2;
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private final String scheme;
    private final String host;
    private final int port;
    private final char[] path;

    public HttpPrefixFetchFilter(URI prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter prefix must not be null.");
        }
        char[] rawScheme = prefix.getRawScheme();
        if (rawScheme == null) {
            throw new IllegalArgumentException("Parameter prefix must have a scheme.");
        }
        String normalisedScheme = HttpPrefixFetchFilter.normalisedScheme(rawScheme);
        if (!HttpPrefixFetchFilter.isHttpOrHttps(normalisedScheme)) {
            throw new IllegalArgumentException("The prefix's scheme must be HTTP or HTTPS.");
        }
        this.scheme = normalisedScheme;
        if (prefix.getRawHost() == null) {
            throw new IllegalArgumentException("Parameter prefix must have a host.");
        }
        try {
            this.host = HttpPrefixFetchFilter.normalisedHost(prefix);
        }
        catch (URIException e) {
            throw new IllegalArgumentException("Failed to obtain the host from the prefix:", e);
        }
        this.port = HttpPrefixFetchFilter.normalisedPort(this.scheme, prefix.getPort());
        this.path = prefix.getRawPath();
    }

    private static String normalisedScheme(char[] scheme) {
        if (scheme == null) {
            return "";
        }
        return new String(scheme).toLowerCase(Locale.ROOT);
    }

    private static boolean isHttpOrHttps(String scheme) {
        return HttpPrefixFetchFilter.isHttp(scheme) || HttpPrefixFetchFilter.isHttps(scheme);
    }

    private static boolean isHttp(String scheme) {
        return HTTP_SCHEME.equals(scheme);
    }

    private static boolean isHttps(String scheme) {
        return HTTPS_SCHEME.equals(scheme);
    }

    private static String normalisedHost(URI uri) throws URIException {
        if (uri.getRawHost() == null) {
            return "";
        }
        return uri.getHost().toLowerCase(Locale.ROOT);
    }

    private static int normalisedPort(String scheme, int port) {
        if (port != -1) {
            return port;
        }
        if (HttpPrefixFetchFilter.isHttp(scheme)) {
            return 80;
        }
        if (HttpPrefixFetchFilter.isHttps(scheme)) {
            return 443;
        }
        return -2;
    }

    public String getNormalisedPrefix() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.scheme).append("://").append(this.host);
        if (!HttpPrefixFetchFilter.isDefaultHttpOrHttpsPort(this.scheme, this.port)) {
            strBuilder.append(':').append(this.port);
        }
        if (this.path != null) {
            strBuilder.append(this.path);
        }
        return strBuilder.toString();
    }

    private static boolean isDefaultHttpOrHttpsPort(String scheme, int port) {
        if (port == 80 && HttpPrefixFetchFilter.isHttp(scheme)) {
            return true;
        }
        return port == 443 && HttpPrefixFetchFilter.isHttps(scheme);
    }

    @Override
    public FetchFilter.FetchStatus checkFilter(URI uri) {
        if (uri == null) {
            return FetchFilter.FetchStatus.OUT_OF_SCOPE;
        }
        String otherScheme = HttpPrefixFetchFilter.normalisedScheme(uri.getRawScheme());
        if (this.port != HttpPrefixFetchFilter.normalisedPort(otherScheme, uri.getPort())) {
            return FetchFilter.FetchStatus.OUT_OF_SCOPE;
        }
        if (!this.scheme.equals(otherScheme)) {
            return FetchFilter.FetchStatus.OUT_OF_SCOPE;
        }
        if (!this.hasSameHost(uri)) {
            return FetchFilter.FetchStatus.OUT_OF_SCOPE;
        }
        if (!HttpPrefixFetchFilter.startsWith(uri.getRawPath(), this.path)) {
            return FetchFilter.FetchStatus.OUT_OF_SCOPE;
        }
        return FetchFilter.FetchStatus.VALID;
    }

    private boolean hasSameHost(URI uri) {
        try {
            return this.host.equals(HttpPrefixFetchFilter.normalisedHost(uri));
        }
        catch (URIException e) {
            LOGGER.warn("Failed to normalise host: {}", (Object)Arrays.toString(uri.getRawHost()), (Object)e);
            return false;
        }
    }

    private static boolean startsWith(char[] array, char[] prefix) {
        if (prefix == null) {
            return true;
        }
        if (array == null) {
            return false;
        }
        int length = prefix.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (prefix[i] == array[i]) continue;
            return false;
        }
        return true;
    }
}

