/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.spider.parser;

import com.stackhawk.hste.spider.SpiderParam;
import com.stackhawk.hste.spider.parser.SpiderParser;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;

@Deprecated
public class SpiderGitParser
extends SpiderParser {
    private static final Pattern gitIndexFilenamePattern = Pattern.compile("/.git/index$");
    private static final Pattern gitIndexContentPattern = Pattern.compile("^DIRC");
    private Pattern GIT_FILE_PATTERN = Pattern.compile("/\\.git/index$");

    public SpiderGitParser(SpiderParam params) {
        super(params);
    }

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        if (message == null || !this.getSpiderParam().isParseGit()) {
            return false;
        }
        this.getLogger().debug("Parsing a Git resource...");
        byte[] data = message.getResponseBody().getBytes();
        String baseURL = message.getRequestHeader().getURI().toString();
        try {
            String fullpath = message.getRequestHeader().getURI().getPath();
            if (fullpath == null) {
                fullpath = "";
            }
            this.getLogger().debug("The full path is [{}]", (Object)fullpath);
            Matcher gitIndexFilenameMatcher = gitIndexFilenamePattern.matcher(fullpath);
            if (!gitIndexFilenameMatcher.find()) {
                this.getLogger().warn("This path cannot be handled by the Git parser: {}", (Object)fullpath);
                return false;
            }
            Matcher gitIndexContentMatcher = gitIndexContentPattern.matcher(new String(data));
            if (!gitIndexContentMatcher.find()) {
                this.getLogger().debug("The file '{}' could not be parsed as a Git Index file due to unexpected content", (Object)fullpath);
                return false;
            }
            ByteBuffer dataBuffer = ByteBuffer.wrap(data);
            byte[] dircArray = new byte[4];
            dataBuffer.get(dircArray, 0, 4);
            int indexFileVersion = dataBuffer.getInt();
            this.getLogger().debug("The Git index file version is {}", (Object)indexFileVersion);
            int indexEntryCount = dataBuffer.getInt();
            this.getLogger().debug("{} entries were found in the Git index file ", (Object)indexEntryCount);
            if (indexFileVersion != 2 && indexFileVersion != 3 && indexFileVersion != 4) {
                throw new Exception("Only Git Index File versions 2, 3, and 4 are currently supported. Git Index File Version " + indexFileVersion + " was found.");
            }
            String previousIndexEntryName = "";
            for (int entryIndex = 0; entryIndex < indexEntryCount; ++entryIndex) {
                int entryBytesRead = 0;
                int indexEntryCtime1 = dataBuffer.getInt();
                entryBytesRead += 4;
                this.getLogger().debug("Entry {} has indexEntryCtime1 {}", (Object)entryIndex, (Object)indexEntryCtime1);
                int indexEntryCtime2 = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryMtime1 = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryMtime2 = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryDev = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryInode = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryMode = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryUid = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryGid = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntrySize = dataBuffer.getInt();
                entryBytesRead += 4;
                this.getLogger().debug("Entry {} has size {}", (Object)entryIndex, (Object)indexEntrySize);
                byte[] indexEntryIdBuffer = new byte[20];
                dataBuffer.get(indexEntryIdBuffer, 0, 20);
                entryBytesRead += 20;
                String indexEntryId = new String(indexEntryIdBuffer);
                short indexEntryFlags = dataBuffer.getShort();
                entryBytesRead += 2;
                this.getLogger().debug("Entry {} has flags {}", (Object)entryIndex, (Object)indexEntryFlags);
                int indexEntryNameByteLength = indexEntryFlags & 0xFFF;
                this.getLogger().debug("Entry {} has a name of length {}", (Object)entryIndex, (Object)indexEntryNameByteLength);
                int indexEntryExtendedFlag = (indexEntryFlags & 0x4000) >> 14;
                this.getLogger().debug("Entry {} has an extended flag of {}", (Object)entryIndex, (Object)indexEntryExtendedFlag);
                if (indexEntryExtendedFlag != 0 && indexEntryExtendedFlag != 1) {
                    throw new Exception("Error parsing out the extended flag for index entry " + entryIndex + ". We got " + indexEntryExtendedFlag);
                }
                if (indexFileVersion == 2 && indexEntryExtendedFlag != 0) {
                    throw new Exception("Index File Version 2 is supposed to have the extended flag set to 0. For index entry " + entryIndex + ", it is set to " + indexEntryExtendedFlag);
                }
                if (indexFileVersion > 2 && indexEntryExtendedFlag == 1) {
                    this.getLogger().debug("For Index file version {}, reading an extra 16 bits for Entry {}", (Object)indexFileVersion, (Object)entryIndex);
                    short indexEntryExtendedFlags = dataBuffer.getShort();
                    entryBytesRead += 2;
                    this.getLogger().debug("Entry {} has (optional) extended flags {}", (Object)entryIndex, (Object)indexEntryExtendedFlags);
                }
                Object indexEntryName = null;
                if (indexFileVersion > 3) {
                    this.getLogger().debug("Inflating the (deflated) entry name for index entry {} based on the previous entry name, since Index file version {} requires this", (Object)entryIndex, (Object)indexFileVersion);
                    int n = 0;
                    int removeNfromPreviousName = 0;
                    int msbsetmask = -128;
                    byte msbunsetmask = (byte)(~msbsetmask & 0xFF);
                    while (++n > 0) {
                        byte byteRead = dataBuffer.get();
                        ++entryBytesRead;
                        removeNfromPreviousName = n == 1 ? removeNfromPreviousName << 8 | 0xFF & (byteRead & msbunsetmask) : removeNfromPreviousName << 8 | 0xFF & (byteRead | msbsetmask);
                        if ((byteRead & msbsetmask) != 0) continue;
                        break;
                    }
                    this.getLogger().debug("We read {} bytes of variable length data from before the start of the entry name", (Object)n);
                    if (n > 4) {
                        throw new Exception("An entry name is never expected to be > 2^^32 bytes long. Some file corruption may have occurred, or a parsing error has occurred");
                    }
                    int bytesToReadCurrentNameEntry = indexEntryNameByteLength - (previousIndexEntryName.length() - removeNfromPreviousName);
                    byte[] indexEntryNameBuffer = new byte[bytesToReadCurrentNameEntry];
                    dataBuffer.get(indexEntryNameBuffer, 0, bytesToReadCurrentNameEntry);
                    entryBytesRead += bytesToReadCurrentNameEntry;
                    indexEntryName = previousIndexEntryName.substring(0, previousIndexEntryName.length() - removeNfromPreviousName) + new String(indexEntryNameBuffer);
                } else {
                    byte[] indexEntryNameBuffer = new byte[indexEntryNameByteLength];
                    dataBuffer.get(indexEntryNameBuffer, 0, indexEntryNameByteLength);
                    entryBytesRead += indexEntryNameByteLength;
                    indexEntryName = new String(indexEntryNameBuffer);
                }
                this.getLogger().debug("Entry {} has name {}", (Object)entryIndex, indexEntryName);
                previousIndexEntryName = indexEntryName;
                byte indexEntryNul = dataBuffer.get();
                ++entryBytesRead;
                if (indexFileVersion < 4) {
                    this.getLogger().debug("Aligning to an 8 byte boundary after Entry {}, since Index file version {} mandates 64 bit alignment for index entries", (Object)entryIndex, (Object)indexFileVersion);
                    int entryBytesToRead = (8 - entryBytesRead % 8) % 8;
                    this.getLogger().debug("The number of bytes read for index entry {} thus far is: {}", (Object)entryIndex, (Object)entryBytesRead);
                    this.getLogger().debug("So we must read {} bytes to stay on a 64 bit boundary", (Object)entryBytesToRead);
                    byte[] indexEntryPadBuffer = new byte[entryBytesToRead];
                    dataBuffer.get(indexEntryPadBuffer, 0, entryBytesToRead);
                    entryBytesRead += entryBytesToRead;
                } else {
                    this.getLogger().debug("Not aligning to an 8 byte boundary after Entry {}, since Index file version {} does not mandate 64 bit alignment for index entries", (Object)entryIndex, (Object)indexFileVersion);
                }
                if (indexEntryName == null || ((String)indexEntryName).length() <= 0) continue;
                this.getLogger().info("Found file/symbolic link/gitlink {} in the Git entries file", indexEntryName);
                this.processURL(message, depth, "../" + (String)indexEntryName, baseURL);
            }
            return true;
        }
        catch (Exception e) {
            this.getLogger().warn("An error occurred trying to parse Git url '{}': ", (Object)baseURL, (Object)e);
            return true;
        }
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyParsed) {
        Matcher matcher = this.GIT_FILE_PATTERN.matcher(path);
        return matcher.find();
    }
}

