/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.utils;

import com.stackhawk.hste.extension.api.ApiException;
import com.stackhawk.hste.model.Context;
import java.util.Locale;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.parosproxy.paros.model.Model;

public final class ApiUtils {
    public static int getIntParam(JSONObject params, String paramName) throws ApiException {
        if (!params.containsKey((Object)paramName)) {
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, paramName);
        }
        try {
            return params.getInt(paramName);
        }
        catch (JSONException e) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, paramName, e);
        }
    }

    public static boolean getBooleanParam(JSONObject params, String paramName) throws ApiException {
        if (!params.containsKey((Object)paramName)) {
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, paramName);
        }
        try {
            return params.getBoolean(paramName);
        }
        catch (JSONException e) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, paramName, e);
        }
    }

    public static String getOptionalStringParam(JSONObject params, String paramName) {
        if (params.containsKey((Object)paramName)) {
            return params.getString(paramName);
        }
        return null;
    }

    public static String getNonEmptyStringParam(JSONObject params, String paramName) throws ApiException {
        if (!params.containsKey((Object)paramName)) {
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, paramName);
        }
        String value = params.getString(paramName);
        if (value == null || value.isEmpty()) {
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, paramName);
        }
        return value;
    }

    public static <E extends Enum<E>> E getOptionalEnumParam(JSONObject params, String paramName, Class<E> enumType) throws ApiException {
        String enumValS = params.optString(paramName, null);
        E enumVal = null;
        if (enumValS != null && !enumValS.isEmpty()) {
            try {
                enumVal = Enum.valueOf(enumType, enumValS);
            }
            catch (Exception ex) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, paramName + ": " + ex.getLocalizedMessage());
            }
        }
        return enumVal;
    }

    public static Context getContextByParamId(JSONObject params, String contextIdParamName) throws ApiException {
        int contextId = ApiUtils.getIntParam(params, contextIdParamName);
        Context context = Model.getSingleton().getSession().getContext(contextId);
        if (context == null) {
            throw new ApiException(ApiException.Type.CONTEXT_NOT_FOUND, contextIdParamName);
        }
        return context;
    }

    public static Context getContextByName(JSONObject parameters, String parameterName) throws ApiException {
        return ApiUtils.getContextByName(parameters.getString(parameterName));
    }

    public static Context getContextByName(String contextName) throws ApiException {
        Context context = Model.getSingleton().getSession().getContext(contextName);
        if (context == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, contextName);
        }
        return context;
    }

    public static String getAuthority(String site) {
        String authority = site;
        boolean isSecure = false;
        if (authority.toLowerCase(Locale.ROOT).startsWith("http://")) {
            authority = authority.substring(7);
        } else if (authority.toLowerCase(Locale.ROOT).startsWith("https://")) {
            authority = authority.substring(8);
            isSecure = true;
        }
        int idx = authority.indexOf(47);
        if (idx > 0) {
            authority = authority.substring(0, idx);
        }
        if (!authority.isEmpty() && authority.indexOf(58) == -1) {
            if (isSecure) {
                return authority + ":443";
            }
            return authority + ":80";
        }
        return authority;
    }

    private ApiUtils() {
    }
}

