/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.utils;

import com.stackhawk.hste.HSTE;
import com.stackhawk.hste.control.AddOn;
import com.stackhawk.hste.control.AddOnLoader;
import com.stackhawk.hste.control.ExtensionFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.WordUtils;
import org.parosproxy.paros.Constant;

public final class HsteSupportUtils {
    private static final String NEWLINE = System.lineSeparator();

    private HsteSupportUtils() {
    }

    public static String getProductName() {
        return "HSTE";
    }

    public static String getVersion() {
        return Constant.messages.getString("support.version.label") + " " + Constant.PROGRAM_VERSION;
    }

    public static String getHsteHomeDirectory() {
        return Constant.messages.getString("support.home.directory.label") + " " + Constant.getHsteHome();
    }

    public static String getHsteInstallDirectory() {
        return Constant.messages.getString("support.install.directory.label") + " " + Constant.getHsteInstall();
    }

    public static String getOperatingSystem() {
        return Constant.messages.getString("support.operating.system.label") + " " + System.getProperty("os.name");
    }

    public static String getArch() {
        return Constant.messages.getString("support.arch.label") + " " + System.getProperty("os.arch");
    }

    public static String getCpuCores() {
        return Constant.messages.getString("support.cpucores.label") + " " + Runtime.getRuntime().availableProcessors();
    }

    public static String getMaxMemory() {
        return Constant.messages.getString("support.maxmem.label") + " " + FileUtils.byteCountToDisplaySize((long)Runtime.getRuntime().maxMemory());
    }

    public static String getJavaVersionVendor() {
        String javaVersion = System.getProperty("java.version");
        String javaVendor = System.getProperty("java.vendor");
        return Constant.messages.getString("support.java.version.label") + " " + javaVendor + " " + javaVersion;
    }

    public static String getLocaleDisplay() {
        return Constant.messages.getString("support.locale.display.label") + " " + String.valueOf(Locale.getDefault(Locale.Category.DISPLAY));
    }

    public static String getLocaleFormat() {
        return Constant.messages.getString("support.locale.format.label") + " " + String.valueOf(Locale.getDefault(Locale.Category.FORMAT));
    }

    public static String getLocaleSystem() {
        return Constant.messages.getString("support.locale.system.label") + " " + String.valueOf(Constant.getSystemsLocale());
    }

    public static String getLookAndFeel() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        Object strLaf = laf != null ? laf.getName() + " (" + laf.getClass().getCanonicalName() + ")" : "[null]";
        return Constant.messages.getString("support.laf.label") + " " + (String)strLaf;
    }

    public static String getInstalledAddons() {
        AddOnLoader addOnLoader = ExtensionFactory.getAddOnLoader();
        ArrayList<AddOn> sortedAddOns = new ArrayList<AddOn>(addOnLoader.getAddOnCollection().getInstalledAddOns());
        Collections.sort(sortedAddOns, new Comparator<AddOn>(){

            @Override
            public int compare(AddOn addOn, AddOn otherAddOn) {
                return addOn.getId().compareTo(otherAddOn.getId());
            }
        });
        return Constant.messages.getString("support.installed.addons.label") + " " + String.valueOf(sortedAddOns);
    }

    public static String getDefaultCharset() {
        return Constant.messages.getString("support.charset.default.label") + " " + String.valueOf(Charset.defaultCharset());
    }

    public static String getAll(boolean formatted) {
        StringBuilder installedAddons = new StringBuilder(200);
        if (formatted) {
            installedAddons.append(NEWLINE);
            installedAddons.append(WordUtils.wrap((String)HsteSupportUtils.getInstalledAddons(), (int)60)).append(NEWLINE);
            installedAddons.append(NEWLINE);
        } else {
            installedAddons.append(HsteSupportUtils.getInstalledAddons()).append(NEWLINE);
        }
        StringBuilder supportDetailsBuilder = new StringBuilder(300);
        supportDetailsBuilder.append(HsteSupportUtils.getProductName()).append(NEWLINE);
        supportDetailsBuilder.append(HsteSupportUtils.getVersion()).append(NEWLINE);
        supportDetailsBuilder.append((CharSequence)installedAddons);
        supportDetailsBuilder.append(HsteSupportUtils.getOperatingSystem()).append(NEWLINE);
        supportDetailsBuilder.append(HsteSupportUtils.getArch()).append(NEWLINE);
        supportDetailsBuilder.append(HsteSupportUtils.getCpuCores()).append(NEWLINE);
        supportDetailsBuilder.append(HsteSupportUtils.getMaxMemory()).append(NEWLINE);
        supportDetailsBuilder.append(HsteSupportUtils.getJavaVersionVendor()).append(NEWLINE);
        supportDetailsBuilder.append(HsteSupportUtils.getLocaleSystem()).append(NEWLINE);
        supportDetailsBuilder.append(HsteSupportUtils.getLocaleDisplay()).append(NEWLINE);
        supportDetailsBuilder.append(HsteSupportUtils.getLocaleFormat()).append(NEWLINE);
        supportDetailsBuilder.append(HsteSupportUtils.getDefaultCharset()).append(NEWLINE);
        supportDetailsBuilder.append(HsteSupportUtils.getHsteHomeDirectory()).append(NEWLINE);
        supportDetailsBuilder.append(HsteSupportUtils.getHsteInstallDirectory()).append(NEWLINE);
        supportDetailsBuilder.append(HsteSupportUtils.getLookAndFeel()).append(NEWLINE);
        return supportDetailsBuilder.toString();
    }

    private static void addFileToZip(ZipOutputStream zipOut, String name, String contents) throws IOException {
        ZipEntry zipEntry = new ZipEntry(name);
        zipOut.putNextEntry(zipEntry);
        zipOut.write(contents.getBytes());
    }

    public static int saveSbomZip(File file) throws IOException {
        int count = 0;
        try (FileOutputStream fos = new FileOutputStream(file);
             ZipOutputStream zipOut = new ZipOutputStream(fos);){
            try (InputStream is = HSTE.class.getResourceAsStream("/bom.json");){
                if (is != null) {
                    HsteSupportUtils.addFileToZip(zipOut, "zap-core-bom.json", IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                    ++count;
                }
            }
            List<AddOn> addOns = ExtensionFactory.getAddOnLoader().getAddOnCollection().getInstalledAddOns();
            for (AddOn addOn : addOns) {
                String sbom = addOn.getSbom();
                if (sbom == null) continue;
                HsteSupportUtils.addFileToZip(zipOut, addOn.getId() + "-bom.json", sbom);
                ++count;
            }
        }
        return count;
    }
}

