/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.regexp.RegexpMatcher;
import net.sf.json.regexp.RegexpUtils;
import net.sf.json.util.JSONUtils;

public final class JsonUtil {
    private static final String FUNCTION_PATTERN = "^function[ ]?\\(.*\\)[ ]?\\{.*\\}$";
    private static final RegexpMatcher FUNCTION_MACTHER = RegexpUtils.getMatcher((String)"^function[ ]?\\(.*\\)[ ]?\\{.*\\}$");

    private JsonUtil() {
    }

    private static boolean isFunction(String value) {
        return FUNCTION_MACTHER.matches(value);
    }

    public static String getJsonFriendlyString(String value) {
        if (!"null".equals(value) && (JSONUtils.mayBeJSON((String)value) || JsonUtil.isFunction(value))) {
            return "'" + value + "'";
        }
        return value;
    }

    public static List<String> toStringList(JSONArray array) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = JSONArray.toCollection((JSONArray)array).iterator();
        while (iter.hasNext()) {
            list.add(iter.next().toString());
        }
        return list;
    }
}

