/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NetworkUtils {
    private static final Logger LOGGER = LogManager.getLogger(NetworkUtils.class);

    private NetworkUtils() {
    }

    public static List<String> getAvailableAddresses(boolean remoteOnly) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                if (n.isLoopback() || !n.isUp()) continue;
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress i = ee.nextElement();
                    if (remoteOnly && i.isSiteLocalAddress()) continue;
                    String addr = i.getHostAddress();
                    if (addr.indexOf(37) > 0) {
                        addr = addr.substring(0, addr.indexOf(37));
                    }
                    list.add(addr);
                }
            }
        }
        catch (SocketException e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }
}

