/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.utils;

import java.util.regex.Pattern;

public final class StringUIUtils {
    public static final String SPACE_SYMBOL = "\u00b7";
    public static final String TAB_SYMBOL = "\u00bb";
    public static final String CARRIAGE_RETURN_SYMBOL = "\u00a4";
    public static final String LINE_FEED_SYMBOL = "\u00b6";

    private StringUIUtils() {
    }

    public static String replaceWithVisibleWhiteSpaceChars(String string) {
        return string.replaceAll("\r", CARRIAGE_RETURN_SYMBOL).replaceAll("\n", LINE_FEED_SYMBOL).replaceAll("\\t", TAB_SYMBOL).replaceAll(" ", SPACE_SYMBOL);
    }

    public static String addVisibleNewLineChars(String string) {
        return string.replaceAll("\r", "\u00a4\r").replaceAll("\n", "\u00b6\n");
    }

    public static boolean containsNewLineChars(String string) {
        return Pattern.compile("\\r?\\n").matcher(string).find();
    }
}

