/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.utils;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.view.View;

public class ThreadUtils {
    private static final Logger LOGGER = LogManager.getLogger(ThreadUtils.class);

    public static void invokeAndWait(Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeAndWait(runnable);
        }
    }

    public static void invokeAndWaitHandled(Runnable runnable) {
        try {
            ThreadUtils.invokeAndWait(runnable);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Error while executing in EDT:", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted while waiting for EDT.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static void invokeLater(Runnable runnable) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }
}

