/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.parosproxy.paros.Constant;

public final class TimeStampUtils {
    private static final String DEFAULT_TIME_STAMP_FORMAT = Constant.messages.getString("timestamp.format.datetime");
    private static final String TIME_STAMP_DELIMITER = Constant.messages.getString("timestamp.format.delimiter");
    private static final String SAFE_TIME_STAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";

    private TimeStampUtils() {
    }

    public static String currentDefaultFormattedTimeStamp() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_TIME_STAMP_FORMAT);
            return sdf.format(new Date());
        }
        catch (IllegalArgumentException e) {
            SimpleDateFormat sdf = new SimpleDateFormat(SAFE_TIME_STAMP_FORMAT);
            return sdf.format(new Date());
        }
    }

    public static String currentFormattedTimeStamp(String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(new Date());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return TimeStampUtils.currentDefaultFormattedTimeStamp();
        }
    }

    public static String getTimeStampedMessage(String message, String format) {
        StringBuilder timeStampedMessage = new StringBuilder(format.length() + TIME_STAMP_DELIMITER.length() + message.length() + 2);
        timeStampedMessage.append(TimeStampUtils.currentFormattedTimeStamp(format));
        timeStampedMessage.append(' ').append(TIME_STAMP_DELIMITER).append(' ');
        timeStampedMessage.append(message);
        return timeStampedMessage.toString();
    }
}

