/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import com.stackhawk.hste.utils.EnableableInterface;
import com.stackhawk.hste.view.AbstractMultipleOptionsBaseTablePanel;
import com.stackhawk.hste.view.AbstractMultipleOptionsTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.parosproxy.paros.Constant;

public abstract class AbstractMultipleOptionsTablePanel<E extends EnableableInterface>
extends AbstractMultipleOptionsBaseTablePanel<E> {
    private static final long serialVersionUID = 1L;
    private static final String ENABLE_ALL_BUTTON_LABEL = Constant.messages.getString("multiple.options.panel.enableAll.button.label");
    private static final String DISABLE_ALL_BUTTON_LABEL = Constant.messages.getString("multiple.options.panel.disableAll.button.label");
    private JButton enableAllButton;
    private JButton disableAllButton;

    public AbstractMultipleOptionsTablePanel(AbstractMultipleOptionsTableModel<E> model) {
        this(model, true);
    }

    protected AbstractMultipleOptionsTablePanel(AbstractMultipleOptionsTableModel<E> model, boolean allowModification) {
        super(model, allowModification);
        boolean buttonsEnabled = this.getModel().getRowCount() > 0;
        this.enableAllButton = new JButton(ENABLE_ALL_BUTTON_LABEL);
        this.enableAllButton.setEnabled(buttonsEnabled);
        this.enableAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AbstractMultipleOptionsTableModel)AbstractMultipleOptionsTablePanel.this.getMultipleOptionsModel()).setAllEnabled(true);
            }
        });
        this.disableAllButton = new JButton(DISABLE_ALL_BUTTON_LABEL);
        this.disableAllButton.setEnabled(buttonsEnabled);
        this.disableAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AbstractMultipleOptionsTableModel)AbstractMultipleOptionsTablePanel.this.getMultipleOptionsModel()).setAllEnabled(false);
            }
        });
        this.addButtonSpacer();
        this.addButton(this.enableAllButton);
        this.addButton(this.disableAllButton);
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (-1 == e.getColumn() || 1 == e.getType() || -1 == e.getType()) {
                    boolean enabled = AbstractMultipleOptionsTablePanel.this.isEnabled() && AbstractMultipleOptionsTablePanel.this.getModel().getRowCount() > 0;
                    AbstractMultipleOptionsTablePanel.this.enableAllButton.setEnabled(enabled);
                    AbstractMultipleOptionsTablePanel.this.disableAllButton.setEnabled(enabled);
                }
            }
        });
    }

    @Override
    public void setComponentEnabled(boolean enabled) {
        super.setComponentEnabled(enabled);
        boolean enable = enabled && this.getModel().getRowCount() > 0;
        this.enableAllButton.setEnabled(enable);
        this.disableAllButton.setEnabled(enable);
    }
}

