/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import com.stackhawk.hste.utils.Orderable;
import com.stackhawk.hste.view.AbstractMultipleOptionsBaseTableModel;

public abstract class AbstractMultipleOrderedOptionsBaseTableModel<E extends Orderable>
extends AbstractMultipleOptionsBaseTableModel<E> {
    private static final long serialVersionUID = 8139923613612787185L;

    @Override
    public void removeElement(int row) {
        boolean updateOrders = row != this.getElements().size() - 1;
        this.getElements().remove(row);
        this.fireTableRowsDeleted(row, row);
        if (updateOrders) {
            this.updateOrdersAndFireNotification(row);
        }
    }

    public void moveTop(int row) {
        Orderable entry = (Orderable)this.getElement(row);
        this.getElements().add(0, entry);
        this.getElements().remove(row + 1);
        this.updateOrdersAndFireNotification(0);
    }

    public void moveUp(int row) {
        Orderable entry = (Orderable)this.getElement(row);
        int firstRow = row - 1;
        this.getElements().add(firstRow, entry);
        this.getElements().remove(row + 1);
        entry.setOrder(row);
        ((Orderable)this.getElements().get(row)).setOrder(row + 1);
        this.fireTableRowsUpdated(firstRow, row);
    }

    public void moveDown(int row) {
        this.moveUp(row + 1);
    }

    public void moveBottom(int row) {
        Orderable entry = (Orderable)this.getElement(row);
        this.getElements().remove(row);
        this.getElements().add(entry);
        this.updateOrdersAndFireNotification(row);
    }

    protected void updateOrdersAndFireNotification(int startingRow) {
        for (int i = startingRow; i < this.getElements().size(); ++i) {
            ((Orderable)this.getElement(i)).setOrder(i + 1);
        }
        this.fireTableDataChanged();
    }
}

