/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import com.stackhawk.hste.utils.DisplayUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class BackgroundImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage img;
    private double scale = 1.0;

    public BackgroundImagePanel() {
        this.img = null;
    }

    public BackgroundImagePanel(URL imageUrl) {
        this.setBackgroundImage(imageUrl);
    }

    public final void setBackgroundImage(URL imageUrl) {
        if (imageUrl != null) {
            try {
                this.img = ImageIO.read(imageUrl);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final void setBackgroundImage(URL imageUrl, double scale) {
        this.setBackgroundImage(imageUrl);
        this.scale = scale;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.img != null) {
            this.setOpaque(false);
            HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).addRenderingHints(hints);
            g.drawImage(this.img, 0, 0, (int)((double)DisplayUtils.getScaledSize(this.img.getWidth()) * this.scale), (int)((double)DisplayUtils.getScaledSize(this.img.getHeight()) * this.scale), null);
        }
        super.paintComponent(g);
    }
}

