/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.model.IllegalContextNameException;
import com.stackhawk.hste.utils.HsteTextArea;
import com.stackhawk.hste.utils.HsteTextField;
import com.stackhawk.hste.view.AbstractContextPropertiesPanel;
import com.stackhawk.hste.view.LayoutHelper;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;

public class ContextGeneralPanel
extends AbstractContextPropertiesPanel {
    private static final long serialVersionUID = -8337361808959321380L;
    private JPanel panelContext = null;
    private HsteTextField txtName = null;
    private HsteTextArea txtDescription = null;
    private JCheckBox chkInScope = null;

    public static String getPanelName(Context ctx) {
        return ContextGeneralPanel.getPanelName(ctx.getId(), ctx.getName());
    }

    public static String getPanelName(int index, String name) {
        return index + ":" + name;
    }

    public ContextGeneralPanel(String name, int contextId) {
        super(contextId);
        this.setName(name);
        this.setLayout(new CardLayout());
        this.add((Component)this.getPanelSession(), this.getName() + "gen");
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            super.setName(name);
            return;
        }
        if (name.startsWith(this.getContextId() + ":")) {
            name = name.substring(name.indexOf(":") + 1);
        }
        super.setName(ContextGeneralPanel.getPanelName(this.getContextId(), name));
    }

    private JPanel getPanelSession() {
        if (this.panelContext == null) {
            this.panelContext = new JPanel();
            this.panelContext.setLayout(new GridBagLayout());
            if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
                this.panelContext.setSize(180, 101);
            }
            this.panelContext.add((Component)new JLabel(Constant.messages.getString("context.label.name")), LayoutHelper.getGBC(0, 0, 1, 1.0));
            this.panelContext.add((Component)this.getTxtName(), LayoutHelper.getGBC(0, 1, 1, 1.0));
            this.panelContext.add((Component)this.getChkInScope(), LayoutHelper.getGBC(0, 2, 2, 1.0));
            this.panelContext.add((Component)new JLabel(Constant.messages.getString("context.label.desc")), LayoutHelper.getGBC(0, 3, 1, 1.0));
            this.panelContext.add((Component)this.getTxtDescription(), LayoutHelper.getGBC(0, 4, 1, 1.0, 1.0));
        }
        return this.panelContext;
    }

    private HsteTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new HsteTextField();
        }
        return this.txtName;
    }

    private JCheckBox getChkInScope() {
        if (this.chkInScope == null) {
            this.chkInScope = new JCheckBox();
            this.chkInScope.setText(Constant.messages.getString("context.inscope.label"));
        }
        return this.chkInScope;
    }

    private HsteTextArea getTxtDescription() {
        if (this.txtDescription == null) {
            this.txtDescription = new HsteTextArea();
            this.txtDescription.setBorder(BorderFactory.createBevelBorder(1));
            this.txtDescription.setLineWrap(true);
        }
        return this.txtDescription;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.contexts";
    }

    @Override
    public void initContextData(Session session, Context uiSharedContext) {
        String firstRegex;
        int startIndex;
        this.getTxtName().setText(uiSharedContext.getName());
        this.getTxtName().discardAllEdits();
        this.getTxtDescription().setText(uiSharedContext.getDescription());
        this.getTxtDescription().discardAllEdits();
        this.getChkInScope().setSelected(uiSharedContext.isInScope());
        if (uiSharedContext.getName().equals(Integer.toString(uiSharedContext.getId())) && uiSharedContext.getIncludeInContextRegexs().size() == 1 && (startIndex = (firstRegex = uiSharedContext.getIncludeInContextRegexs().get(0)).indexOf("://")) > 0) {
            String hostPlus = firstRegex.substring(startIndex + 3);
            int endIndex = hostPlus.indexOf("\\");
            if (endIndex > 0) {
                hostPlus = hostPlus.substring(0, endIndex);
            }
            if ((endIndex = hostPlus.indexOf("/")) > 0) {
                hostPlus = hostPlus.substring(0, endIndex);
            }
            this.getTxtName().setText(hostPlus);
        }
    }

    @Override
    public void validateContextData(Session session) throws Exception {
        String name = this.getTxtName().getText();
        if (name == null || name.isEmpty()) {
            throw new IllegalContextNameException(IllegalContextNameException.Reason.EMPTY_NAME, Constant.messages.getString("context.error.name.empty"));
        }
        if (!this.getName().equals(ContextGeneralPanel.getPanelName(this.getContextId(), name)) && session.getContext(name) != null) {
            throw new IllegalContextNameException(IllegalContextNameException.Reason.DUPLICATED_NAME, Constant.messages.getString("context.error.name.duplicated"));
        }
    }

    @Override
    public void saveContextData(Session session) {
        Context context = session.getContext(this.getContextId());
        this.saveDataInContext(context);
        String name = this.getTxtName().getText();
        if (!this.getName().equals(ContextGeneralPanel.getPanelName(this.getContextId(), name)) && View.isInitialised()) {
            View.getSingleton().renameContext(context);
        }
    }

    @Override
    public void saveTemporaryContextData(Context uiSharedContext) {
        this.saveDataInContext(uiSharedContext);
    }

    private void saveDataInContext(Context context) {
        context.setName(this.getTxtName().getText());
        context.setDescription(this.getTxtDescription().getText());
        context.setInScope(this.getChkInScope().isSelected());
    }
}

