/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class ContextsSitesPanel
extends JPanel {
    private static final long serialVersionUID = -3325400144404304335L;

    public ContextsSitesPanel(JTree contextsTree, JTree sitesTree) {
        this(contextsTree, sitesTree, null);
    }

    public ContextsSitesPanel(JTree contextsTree, JTree sitesTree, String scrollPaneName) {
        super(new BorderLayout());
        ContextsSitesPanel.validateNonNull(contextsTree, "contextsTree");
        ContextsSitesPanel.validateNonNull(sitesTree, "sitesTree");
        JScrollPane scrollPane = new JScrollPane();
        if (scrollPaneName != null) {
            scrollPane.setName(scrollPaneName);
        }
        ScrollableTreesPanel panel = new ScrollableTreesPanel(contextsTree, sitesTree);
        scrollPane.setViewportView(panel);
        this.add(scrollPane);
    }

    private static void validateNonNull(Object parameter, String parameterName) {
        if (parameter == null) {
            throw new IllegalArgumentException("The " + parameterName + " must not be null.");
        }
    }

    private static class ScrollableTreesPanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 2709986817434976954L;
        private final JTree contextsTree;
        private final JTree sitesTree;

        public ScrollableTreesPanel(JTree contextsTree, JTree sitesTree) {
            super(new BorderLayout());
            this.contextsTree = contextsTree;
            this.add((Component)contextsTree, "North");
            this.sitesTree = sitesTree;
            this.add((Component)sitesTree, "Center");
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension dNT = this.contextsTree.getPreferredScrollableViewportSize();
            Dimension dCT = this.sitesTree.getPreferredScrollableViewportSize();
            dCT.setSize(Math.max(dNT.getWidth(), dCT.getWidth()), dNT.getHeight() + dCT.getHeight());
            return dCT;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            int unitIncrement;
            if (visibleRect.getY() < this.sitesTree.getBounds().getY() && (unitIncrement = this.contextsTree.getScrollableUnitIncrement(visibleRect, orientation, direction)) != 0) {
                return unitIncrement;
            }
            return this.sitesTree.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.sitesTree.getScrollableBlockIncrement(visibleRect, orientation, direction);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            int width = Math.max(this.sitesTree.getPreferredSize().width, this.contextsTree.getPreferredSize().width);
            return SwingUtilities.getUnwrappedParent(this).getWidth() > width;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return SwingUtilities.getUnwrappedParent(this).getHeight() > this.sitesTree.getPreferredSize().height + this.contextsTree.getPreferredSize().height;
        }
    }
}

