/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;

public class HrefTypeInfo
implements Comparable<HrefTypeInfo> {
    private static final Logger LOGGER = LogManager.getLogger(HrefTypeInfo.class);
    static final Map<Integer, HrefTypeInfo> values = new HashMap<Integer, HrefTypeInfo>();
    public static final HrefTypeInfo NO_TYPE;
    public static final HrefTypeInfo UNDEFINED_TYPE;
    private final int source;
    private final String name;
    private Icon icon;

    public HrefTypeInfo(int source, String name) {
        this.source = source;
        this.name = name;
        this.icon = HrefTypeInfo.createIcon(source);
    }

    public HrefTypeInfo(int source, String name, Icon icon) {
        this.source = source;
        this.name = name;
        this.icon = icon;
    }

    public int getType() {
        return this.source;
    }

    public Icon getIcon() {
        return this.icon;
    }

    private static Icon createIcon(int source) {
        if (!View.isInitialised()) {
            return null;
        }
        switch (source) {
            case 1: 
            case 16: {
                return new ImageIcon(HrefTypeInfo.class.getResource("/resource/icon/16/doublearrow.png"));
            }
            case 11: {
                return new ImageIcon(HrefTypeInfo.class.getResource("/resource/icon/16/181.png"));
            }
        }
        return null;
    }

    public int hashCode() {
        return 31 + this.source;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HrefTypeInfo other = (HrefTypeInfo)object;
        return this.source == other.source;
    }

    @Override
    public int compareTo(HrefTypeInfo other) {
        return this.name.compareTo(other.name);
    }

    public String toString() {
        return this.name;
    }

    public static HrefTypeInfo getFromType(int type) {
        if (type == -1) {
            return NO_TYPE;
        }
        HrefTypeInfo hrefTypeInfo = values.get(type);
        if (hrefTypeInfo == null) {
            return UNDEFINED_TYPE;
        }
        return hrefTypeInfo;
    }

    public static void addType(HrefTypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo);
        int type = typeInfo.getType();
        if (type == HrefTypeInfo.NO_TYPE.source || type == HrefTypeInfo.UNDEFINED_TYPE.source) {
            LOGGER.warn("Attempting to override logic type: {}", (Object)type);
            return;
        }
        if (values.containsKey(type)) {
            LOGGER.warn("Attempting to add an existing type: {}", (Object)type);
            return;
        }
        HrefTypeInfo.addTypeImpl(typeInfo);
    }

    private static void addTypeImpl(HrefTypeInfo typeInfo) {
        values.put(typeInfo.getType(), typeInfo);
    }

    public static void removeType(HrefTypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo);
        values.remove(typeInfo.getType());
    }

    static {
        HrefTypeInfo.addTypeImpl(new HrefTypeInfo(1, Constant.messages.getString("view.href.type.name.proxy")));
        HrefTypeInfo.addTypeImpl(new HrefTypeInfo(16, Constant.messages.getString("view.href.type.name.proxy")));
        HrefTypeInfo.addTypeImpl(new HrefTypeInfo(11, Constant.messages.getString("view.href.type.name.auth")));
        NO_TYPE = new HrefTypeInfo(-1, "");
        UNDEFINED_TYPE = new HrefTypeInfo(-2, Constant.messages.getString("view.href.type.name.undefined"));
    }
}

