/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import java.awt.Component;
import java.text.Collator;
import java.util.Comparator;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class HsteSortedMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private final Comparator<JMenuItem> comparator;

    public HsteSortedMenu() {
        this((item1, item2) -> Collator.getInstance().compare(item1.getText(), item2.getText()));
    }

    public HsteSortedMenu(Comparator<JMenuItem> comparator) {
        this.comparator = comparator;
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        super.add((Component)menuItem, this.getSortedIndex(menuItem));
        return menuItem;
    }

    @Override
    public Component add(Component c) {
        return super.add(c, this.getSortedIndex(c));
    }

    @Override
    public Component add(Component c, int index) {
        return this.add(c);
    }

    @Override
    public void insert(String s, int pos) {
        this.add(s);
    }

    @Override
    public JMenuItem insert(JMenuItem mi, int pos) {
        return this.add(mi);
    }

    @Override
    public JMenuItem insert(Action a, int pos) {
        return this.add(a);
    }

    private int getSortedIndex(Component comp) {
        if (!(comp instanceof JMenuItem)) {
            return -1;
        }
        int pos = 0;
        for (int i = 0; i < this.getItemCount() && this.comparator.compare((JMenuItem)comp, this.getItem(i)) >= 0; ++i) {
            pos = i + 1;
        }
        return pos;
    }
}

