/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;

public class HsteToggleButton
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    private String defaultToolTipText;
    private String selectedToolTipText;
    private String disabledToolTipText;
    private String disabledSelectedToolTipText;
    private ToolTipTextUpdaterOnSelectionStateChange toolTipTextUpdaterOnSelectionStateChange;

    public HsteToggleButton() {
        super(null, null, false);
    }

    public HsteToggleButton(Icon icon) {
        super(null, icon, false);
    }

    public HsteToggleButton(Icon icon, boolean selected) {
        super(null, icon, selected);
    }

    public HsteToggleButton(String text) {
        super(text, null, false);
    }

    public HsteToggleButton(String text, boolean selected) {
        super(text, null, selected);
    }

    public HsteToggleButton(Action action) {
        super(action);
    }

    public HsteToggleButton(String text, Icon icon) {
        super(text, icon, false);
    }

    public HsteToggleButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.updateCurrentToolTipText();
    }

    private void updateCurrentToolTipText() {
        boolean disabled = !this.isEnabled();
        boolean selected = this.isSelected();
        String toolTipText = disabled && selected && this.disabledSelectedToolTipText != null ? this.disabledSelectedToolTipText : (disabled && this.disabledToolTipText != null ? this.disabledToolTipText : (selected && this.selectedToolTipText != null ? this.selectedToolTipText : this.defaultToolTipText));
        super.setToolTipText(toolTipText);
    }

    @Override
    public void setToolTipText(String text) {
        this.defaultToolTipText = text;
        this.updateCurrentToolTipText();
    }

    @Override
    public String getToolTipText() {
        return super.getToolTipText();
    }

    public String getDefaultToolTipText() {
        return this.defaultToolTipText;
    }

    public void setSelectedToolTipText(String text) {
        this.selectedToolTipText = text;
        this.addRemoveToolTipTextUpdaterOnSelectionStateChangeAsNeeded();
        this.updateCurrentToolTipText();
    }

    private void addRemoveToolTipTextUpdaterOnSelectionStateChangeAsNeeded() {
        if (this.selectedToolTipText == null && this.disabledSelectedToolTipText == null) {
            if (this.toolTipTextUpdaterOnSelectionStateChange != null) {
                this.removeItemListener(this.toolTipTextUpdaterOnSelectionStateChange);
                this.toolTipTextUpdaterOnSelectionStateChange = null;
            }
        } else if (this.toolTipTextUpdaterOnSelectionStateChange == null) {
            this.toolTipTextUpdaterOnSelectionStateChange = new ToolTipTextUpdaterOnSelectionStateChange();
            this.addItemListener(this.toolTipTextUpdaterOnSelectionStateChange);
        }
    }

    public String getSelectedToolTipText() {
        return this.selectedToolTipText;
    }

    public void setDisabledToolTipText(String text) {
        this.disabledToolTipText = text;
        this.updateCurrentToolTipText();
    }

    public String getDisabledToolTipText() {
        return this.disabledToolTipText;
    }

    public void setDisabledSelectedToolTipText(String text) {
        this.disabledSelectedToolTipText = text;
        this.addRemoveToolTipTextUpdaterOnSelectionStateChangeAsNeeded();
        this.updateCurrentToolTipText();
    }

    public String getDisabledSelectedToolTipText() {
        return this.disabledSelectedToolTipText;
    }

    private class ToolTipTextUpdaterOnSelectionStateChange
    implements ItemListener {
        private ToolTipTextUpdaterOnSelectionStateChange() {
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (701 == evt.getID()) {
                HsteToggleButton.this.updateCurrentToolTipText();
            }
        }
    }
}

