/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import com.stackhawk.hste.utils.DisplayUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;

public class MainToolbarPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(MainToolbarPanel.class);
    private JToolBar toolbar = null;
    private JComboBox<String> modeSelect = null;
    private JButton btnNew = null;
    private JButton btnOpen = null;
    private JButton btnSave = null;
    private JButton btnSnapshot = null;
    private JButton btnSession = null;
    private JButton btnOptions = null;

    public MainToolbarPanel() {
        this.initialise();
    }

    public void initialise() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(DisplayUtils.getScaledDimension(this.getMaximumSize().width, 25));
        this.setMaximumSize(DisplayUtils.getScaledDimension(this.getMaximumSize().width, 25));
        this.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.fill = 2;
        this.add((Component)this.getToolbar(), gridBagConstraints1);
        this.add(Box.createHorizontalGlue(), gridBagConstraints2);
        this.toolbar.add(this.getModeSelect());
        this.toolbar.add(this.getBtnNew());
        this.toolbar.add(this.getBtnOpen());
        this.toolbar.add(this.getBtnSave());
        this.toolbar.add(this.getBtnSnapshot());
        this.toolbar.add(this.getBtnSession());
        this.toolbar.add(this.getBtnOptions());
        this.toolbar.addSeparator();
    }

    private JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setEnabled(true);
            this.toolbar.setFloatable(false);
            this.toolbar.setRollover(true);
            this.toolbar.setName("Main Toolbar");
            this.toolbar.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.toolbar;
    }

    public void addToolBarComponent(Component component) {
        this.validateComponentNonNull(component);
        if (component instanceof JButton) {
            this.addButton((JButton)component);
        } else if (component instanceof JToggleButton) {
            this.addButton((JToggleButton)component);
        } else {
            this.getToolbar().add(component);
            this.revalidateAndRepaintToolbar();
        }
    }

    private void validateComponentNonNull(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("The component must not be null.");
        }
    }

    private void revalidateAndRepaintToolbar() {
        this.getToolbar().revalidate();
        this.getToolbar().repaint();
    }

    public void removeToolBarComponent(Component component) {
        this.validateComponentNonNull(component);
        this.getToolbar().remove(component);
        this.revalidateAndRepaintToolbar();
    }

    public void addButton(JButton button) {
        DisplayUtils.scaleIcon(button);
        this.getToolbar().add(button);
        this.revalidateAndRepaintToolbar();
    }

    public void removeButton(JButton button) {
        this.removeToolBarComponent(button);
    }

    public void addButton(JToggleButton button) {
        DisplayUtils.scaleIcon(button);
        this.getToolbar().add(button);
        this.revalidateAndRepaintToolbar();
    }

    public void removeButton(JToggleButton button) {
        this.removeToolBarComponent(button);
    }

    public void addSeparator() {
        this.getToolbar().addSeparator();
        this.revalidateAndRepaintToolbar();
    }

    public void addSeparator(JToolBar.Separator separator) {
        this.getToolbar().add(separator);
        this.revalidateAndRepaintToolbar();
    }

    public void removeSeparator(JToolBar.Separator separator) {
        this.removeToolBarComponent(separator);
    }

    private JComboBox<String> getModeSelect() {
        if (this.modeSelect == null) {
            this.modeSelect = new JComboBox();
            this.modeSelect.addItem(Constant.messages.getString("view.toolbar.mode.safe.select"));
            this.modeSelect.addItem(Constant.messages.getString("view.toolbar.mode.protect.select"));
            this.modeSelect.addItem(Constant.messages.getString("view.toolbar.mode.standard.select"));
            this.modeSelect.addItem(Constant.messages.getString("view.toolbar.mode.attack.select"));
            this.modeSelect.setToolTipText(Constant.messages.getString("view.toolbar.mode.tooltip"));
            this.modeSelect.getAccessibleContext().setAccessibleName(Constant.messages.getString("view.toolbar.mode.tooltip"));
            ToolTipManager.sharedInstance().setDismissDelay(12000);
            ToolTipManager.sharedInstance().registerComponent(this.modeSelect);
            Control.Mode mode = Control.Mode.valueOf(Model.getSingleton().getOptionsParam().getViewParam().getMode());
            switch (mode) {
                case safe: {
                    this.modeSelect.setSelectedIndex(0);
                    break;
                }
                case protect: {
                    this.modeSelect.setSelectedIndex(1);
                    break;
                }
                case standard: {
                    this.modeSelect.setSelectedIndex(2);
                    break;
                }
                case attack: {
                    this.modeSelect.setSelectedIndex(3);
                }
            }
            this.modeSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Control.Mode mode = null;
                    switch (MainToolbarPanel.this.modeSelect.getSelectedIndex()) {
                        case 0: {
                            mode = Control.Mode.safe;
                            break;
                        }
                        case 1: {
                            mode = Control.Mode.protect;
                            break;
                        }
                        case 2: {
                            mode = Control.Mode.standard;
                            break;
                        }
                        case 3: {
                            mode = Control.Mode.attack;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    Control.getSingleton().setMode(mode);
                    View.getSingleton().getMainFrame().getMainMenuBar().setMode(mode);
                }
            });
        }
        return this.modeSelect;
    }

    public void setMode(final Control.Mode mode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainToolbarPanel.this.getModeSelect().setSelectedItem(Constant.messages.getString("view.toolbar.mode." + mode.name() + ".select"));
            }
        });
    }

    private JButton getBtnNew() {
        if (this.btnNew == null) {
            this.btnNew = new JButton();
            this.btnNew.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/16/021.png"))));
            this.btnNew.setToolTipText(Constant.messages.getString("menu.file.newSession"));
            this.btnNew.getAccessibleContext().setAccessibleName(Constant.messages.getString("menu.file.newSession"));
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Control.getSingleton().getMenuFileControl().newSession(true);
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.newSession.error"));
                    }
                }
            });
        }
        return this.btnNew;
    }

    private JButton getBtnOpen() {
        if (this.btnOpen == null) {
            this.btnOpen = new JButton();
            this.btnOpen.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/16/047.png"))));
            this.btnOpen.setToolTipText(Constant.messages.getString("menu.file.openSession"));
            this.btnOpen.getAccessibleContext().setAccessibleName(Constant.messages.getString("menu.file.openSession"));
            this.btnOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Control.getSingleton().getMenuFileControl().openSession();
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.openSession.error"));
                    }
                }
            });
        }
        return this.btnOpen;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/16/096.png"))));
            this.btnSave.setToolTipText(Constant.messages.getString("menu.file.persistSession"));
            this.btnSave.getAccessibleContext().setAccessibleName(Constant.messages.getString("menu.file.persistSession"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (Model.getSingleton().getSession().isNewState()) {
                            Control.getSingleton().getMenuFileControl().saveAsSession();
                        } else {
                            View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.sessionExists.error"));
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.persistSession.error"));
                    }
                }
            });
        }
        return this.btnSave;
    }

    private JButton getBtnSnapshot() {
        if (this.btnSnapshot == null) {
            this.btnSnapshot = new JButton();
            this.btnSnapshot.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/fugue/camera.png"))));
            this.btnSnapshot.setToolTipText(Constant.messages.getString("menu.file.snapshotSession"));
            this.btnSnapshot.getAccessibleContext().setAccessibleName(Constant.messages.getString("menu.file.snapshotSession"));
            this.btnSnapshot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (Model.getSingleton().getSession().isNewState()) {
                            View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.sessionNotExist.error"));
                        } else {
                            Control.getSingleton().getMenuFileControl().saveSnapshot();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.persistSession.error"));
                    }
                }
            });
        }
        return this.btnSnapshot;
    }

    private JButton getBtnSession() {
        if (this.btnSession == null) {
            this.btnSession = new JButton();
            this.btnSession.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/16/024.png"))));
            this.btnSession.setToolTipText(Constant.messages.getString("menu.file.sessionProperties"));
            this.btnSession.getAccessibleContext().setAccessibleName(Constant.messages.getString("menu.file.sessionProperties"));
            this.btnSession.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Control.getSingleton().getMenuFileControl().properties();
                }
            });
        }
        return this.btnSession;
    }

    private JButton getBtnOptions() {
        if (this.btnOptions == null) {
            this.btnOptions = new JButton();
            this.btnOptions.setToolTipText(Constant.messages.getString("menu.tools.options"));
            this.btnOptions.getAccessibleContext().setAccessibleName(Constant.messages.getString("menu.tools.options"));
            this.btnOptions.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(MainToolbarPanel.class.getResource("/resource/icon/16/041.png"))));
            this.btnOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Control.getSingleton().getMenuToolsControl().options();
                }
            });
        }
        return this.btnOptions;
    }

    public void sessionChanged(Session session) {
        if (session != null) {
            this.getBtnSave().setEnabled(session.isNewState());
            this.getBtnSnapshot().setEnabled(!session.isNewState());
        }
    }
}

