/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;

public class PositiveValuesSlider
extends JSlider {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MINOR_TICK_SPACING = 1;
    private static final int DEFAULT_MAJOR_TICK_SPACING = 5;

    public PositiveValuesSlider(int max) {
        this(1, max);
    }

    public PositiveValuesSlider(int value, int max) {
        super(new PositiveValuesBoundedRangeModel(value, max));
        this.setMinorTickSpacing(1);
        this.setMajorTickSpacing(5);
        this.setPaintTicks(true);
        this.setPaintLabels(true);
        this.setSnapToTicks(true);
        this.setPaintTrack(true);
    }

    @Override
    public void setMajorTickSpacing(int n) {
        this.setLabelTable(null);
        super.setMajorTickSpacing(n);
    }

    @Override
    public void setModel(BoundedRangeModel newModel) {
        if (!(newModel instanceof PositiveValuesBoundedRangeModel)) {
            return;
        }
        super.setModel(newModel);
    }

    private static class PositiveValuesBoundedRangeModel
    extends DefaultBoundedRangeModel {
        private static final long serialVersionUID = 1L;

        public PositiveValuesBoundedRangeModel(int value, int max) {
            super(PositiveValuesBoundedRangeModel.getValueGreaterThanZero(value), 0, 0, max);
        }

        @Override
        public void setMinimum(int n) {
        }

        @Override
        public void setValue(int value) {
            super.setValue(PositiveValuesBoundedRangeModel.getValueGreaterThanZero(value));
        }

        private static int getValueGreaterThanZero(int value) {
            return Math.max(value, 1);
        }
    }
}

