/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import com.stackhawk.hste.utils.DisplayUtils;
import com.stackhawk.hste.view.OverlayIcon;
import com.stackhawk.hste.view.SiteMapListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;

public class SiteMapTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final ImageIcon ROOT_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/16/094.png"));
    private static final ImageIcon LEAF_IN_SCOPE_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/document-target.png"));
    private static final ImageIcon LEAF_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/document.png"));
    private static final ImageIcon FOLDER_OPEN_IN_SCOPE_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/folder-horizontal-open-target.png"));
    private static final ImageIcon FOLDER_OPEN_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/folder-horizontal-open.png"));
    private static final ImageIcon FOLDER_CLOSED_IN_SCOPE_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/folder-horizontal-target.png"));
    private static final ImageIcon FOLDER_CLOSED_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/folder-horizontal.png"));
    private static final ImageIcon DATA_DRIVEN_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/database.png"));
    private static final ImageIcon DATA_DRIVEN_IN_SCOPE_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/database-target.png"));
    private static final ImageIcon LOCK_OVERLAY_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/lock-overlay.png"));
    private static final long serialVersionUID = -4278691012245035225L;
    private static final Logger LOGGER = LogManager.getLogger(SiteMapTreeCellRenderer.class);
    private List<SiteMapListener> listeners;
    private JPanel component;

    public SiteMapTreeCellRenderer(List<SiteMapListener> listeners) {
        this.listeners = listeners;
        this.component = new JPanel(new FlowLayout(1, 4, 2));
        this.component.setOpaque(false);
        this.setLabelFor(this.component);
        this.putClientProperty("html.disable", Boolean.TRUE);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.component.removeAll();
        SiteNode node = null;
        if (value instanceof SiteNode) {
            node = (SiteNode)value;
        }
        if (node != null) {
            if (node.isFiltered()) {
                this.setPreferredSize(new Dimension(0, 0));
                return this;
            }
            this.setPreferredSize(null);
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (node.isRoot()) {
                this.component.add(this.wrap(DisplayUtils.getScaledIcon(ROOT_ICON)));
            } else {
                OverlayIcon icon = node.isDataDriven() ? (node.isIncludedInScope() && !node.isExcludedFromScope() ? new OverlayIcon(DATA_DRIVEN_IN_SCOPE_ICON) : new OverlayIcon(DATA_DRIVEN_ICON)) : (leaf ? (node.isIncludedInScope() && !node.isExcludedFromScope() ? new OverlayIcon(LEAF_IN_SCOPE_ICON) : new OverlayIcon(LEAF_ICON)) : (expanded ? (node.isIncludedInScope() && !node.isExcludedFromScope() ? new OverlayIcon(FOLDER_OPEN_IN_SCOPE_ICON) : new OverlayIcon(FOLDER_OPEN_ICON)) : (node.isIncludedInScope() && !node.isExcludedFromScope() ? new OverlayIcon(FOLDER_CLOSED_IN_SCOPE_ICON) : new OverlayIcon(FOLDER_CLOSED_ICON))));
                if (node.getParent().isRoot() && node.getNodeName().startsWith("https://")) {
                    icon.add(LOCK_OVERLAY_ICON);
                }
                this.component.add(this.wrap(DisplayUtils.getScaledIcon(icon)));
                Alert alert = node.getHighestAlert();
                if (alert != null) {
                    this.component.add(this.wrap(alert.getIcon()));
                }
                for (ImageIcon ci : node.getCustomIcons()) {
                    this.component.add(this.wrap(DisplayUtils.getScaledIcon(ci)));
                }
            }
            this.setText(node.toString());
            this.setIcon(null);
            this.component.add(this);
            for (SiteMapListener listener : this.listeners) {
                listener.onReturnNodeRendererComponent(this, leaf, node);
            }
            return this.component;
        }
        return this;
    }

    private JLabel wrap(ImageIcon icon) {
        JLabel label = new JLabel(icon);
        label.setOpaque(false);
        label.putClientProperty("html.disable", Boolean.TRUE);
        return label;
    }

    public HistoryReference getHistoryReferenceFromNode(Object value) {
        SiteNode node = null;
        if (value instanceof SiteNode && (node = (SiteNode)value).getHistoryReference() != null) {
            try {
                return node.getHistoryReference();
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

