/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import com.stackhawk.hste.model.StructuralNodeModifier;
import com.stackhawk.hste.view.AbstractMultipleOptionsTableModel;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;

public class StructuralNodeModifiersTableModel
extends AbstractMultipleOptionsTableModel<StructuralNodeModifier> {
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("context.ddn.table.header.type"), Constant.messages.getString("context.ddn.table.header.name"), Constant.messages.getString("context.ddn.table.header.regex")};
    private static final long serialVersionUID = 4463944219657112162L;
    private List<StructuralNodeModifier> snms = new ArrayList<StructuralNodeModifier>();

    public StructuralNodeModifiersTableModel(List<StructuralNodeModifier> snms) {
        this.snms = new ArrayList<StructuralNodeModifier>(snms);
    }

    public StructuralNodeModifiersTableModel() {
        this.snms = new ArrayList<StructuralNodeModifier>();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.snms.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                switch (this.snms.get(rowIndex).getType()) {
                    case StructuralParameter: {
                        return Constant.messages.getString("context.ddn.table.type.struct");
                    }
                    case DataDrivenNode: {
                        return Constant.messages.getString("context.ddn.table.type.data");
                    }
                }
                return null;
            }
            case 1: {
                return this.snms.get(rowIndex).getName();
            }
            case 2: {
                if (this.snms.get(rowIndex).getPattern() != null) {
                    return this.snms.get(rowIndex).getPattern().pattern();
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public List<StructuralNodeModifier> getElements() {
        return this.snms;
    }

    public List<StructuralNodeModifier> getStructuralNodeModifiers() {
        return this.snms;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void setStructuralNodeModifiers(List<StructuralNodeModifier> snms) {
        this.snms = new ArrayList<StructuralNodeModifier>(snms);
        this.fireTableDataChanged();
    }

    public void addStructuralNodeModifiers(List<StructuralNodeModifier> snms) {
        this.snms.addAll(snms);
        this.fireTableDataChanged();
    }

    public void removeAllStructuralNodeModifiers() {
        this.snms = new ArrayList<StructuralNodeModifier>();
        this.fireTableDataChanged();
    }

    public void addStructuralNodeModifier(StructuralNodeModifier snm) {
        this.snms.add(snm);
        this.fireTableRowsInserted(this.snms.size() - 1, this.snms.size() - 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }
}

