/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view;

import com.stackhawk.hste.model.Tech;
import com.stackhawk.hste.model.TechSet;
import com.stackhawk.hste.view.JCheckBoxTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TechnologyTreePanel
extends JPanel {
    private static final long serialVersionUID = 5514692105773714202L;
    private final JCheckBoxTree techTree;
    private final HashMap<Tech, DefaultMutableTreeNode> techToNodeMap;
    private final DefaultMutableTreeNode root;

    public TechnologyTreePanel(String nameRootNode) {
        this.setLayout(new BorderLayout());
        this.techToNodeMap = new HashMap();
        this.techTree = new JCheckBoxTree(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void setExpandedState(TreePath path, boolean state) {
                if (state) {
                    super.setExpandedState(path, state);
                }
            }
        };
        this.root = new DefaultMutableTreeNode(nameRootNode);
        this.refresh();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.techTree);
        scrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.add((Component)scrollPane, "Center");
    }

    public void refresh() {
        this.root.removeAllChildren();
        this.techToNodeMap.clear();
        for (Tech tech : Tech.getAll()) {
            DefaultMutableTreeNode parent = tech.getParent() != null ? this.techToNodeMap.get(tech.getParent()) : null;
            if (parent == null) {
                parent = this.root;
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(tech.getUiName());
            parent.add(node);
            this.techToNodeMap.put(tech, node);
        }
        this.techTree.setModel(new DefaultTreeModel(this.root));
        this.techTree.expandAll();
        this.techTree.setCheckBoxEnabled(new TreePath(this.root), false);
        this.reset();
    }

    public void setTechSet(TechSet techSet) {
        TreeSet<Tech> includedTech = techSet.getIncludeTech();
        for (Map.Entry<Tech, DefaultMutableTreeNode> node : this.techToNodeMap.entrySet()) {
            TreePath tp = this.getPath(node.getValue());
            Tech tech = node.getKey();
            if (Tech.getTopLevel().contains(tech)) {
                this.techTree.check(tp, TechnologyTreePanel.containsAnyOfTopLevelTech(includedTech, tech));
                continue;
            }
            this.techTree.check(tp, techSet.includes(tech));
        }
    }

    public TechSet getTechSet() {
        TechSet techSet = new TechSet();
        for (Map.Entry<Tech, DefaultMutableTreeNode> node : this.techToNodeMap.entrySet()) {
            TreePath tp = this.getPath(node.getValue());
            Tech tech = node.getKey();
            if (this.techTree.isSelectedFully(tp)) {
                techSet.include(tech);
                continue;
            }
            techSet.exclude(tech);
        }
        return techSet;
    }

    public void reset() {
        this.techTree.checkSubTree(this.techTree.getPathForRow(0), true);
    }

    private TreePath getPath(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    private static boolean containsAnyOfTopLevelTech(Set<Tech> techSet, Tech topLevelTech) {
        for (Tech tech : techSet) {
            if (!topLevelTech.equals(tech.getParent())) continue;
            return true;
        }
        return false;
    }
}

