/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.messagecontainer.http;

import com.stackhawk.hste.view.messagecontainer.http.DefaultMultipleHistoryReferencesContainer;
import com.stackhawk.hste.view.messagecontainer.http.PersistedHttpMessagesList;
import com.stackhawk.hste.view.messagecontainer.http.SelectableHistoryReferencesContainer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;

public class DefaultSelectableHistoryReferencesContainer
extends DefaultMultipleHistoryReferencesContainer
implements SelectableHistoryReferencesContainer {
    private final List<HistoryReference> selectedHistoryReferences;
    private final List<HttpMessage> selectedHttpMessages;

    public DefaultSelectableHistoryReferencesContainer(String name, Component component) {
        this(name, component, null, null);
    }

    public DefaultSelectableHistoryReferencesContainer(String name, Component component, List<HistoryReference> historyReferences) {
        this(name, component, historyReferences, null);
    }

    public DefaultSelectableHistoryReferencesContainer(String name, Component component, List<HistoryReference> historyReferences, List<HistoryReference> selectedHistoryReferences) {
        super(name, component, historyReferences);
        if (selectedHistoryReferences == null || selectedHistoryReferences.isEmpty()) {
            this.selectedHistoryReferences = Collections.emptyList();
            this.selectedHttpMessages = Collections.emptyList();
        } else {
            this.selectedHistoryReferences = Collections.unmodifiableList(new ArrayList<HistoryReference>(selectedHistoryReferences));
            this.selectedHttpMessages = new PersistedHttpMessagesList(selectedHistoryReferences);
        }
    }

    @Override
    public boolean hasSelectedMessages() {
        return !this.selectedHttpMessages.isEmpty();
    }

    @Override
    public boolean isOnlyOneMessageSelected() {
        return this.selectedHttpMessages.size() == 1;
    }

    @Override
    public HttpMessage getSelectedMessage() {
        if (this.hasSelectedMessages()) {
            return this.selectedHttpMessages.get(0);
        }
        return null;
    }

    @Override
    public int getNumberOfSelectedMessages() {
        return this.selectedHttpMessages.size();
    }

    @Override
    public List<HttpMessage> getSelectedMessages() {
        return this.selectedHttpMessages;
    }

    @Override
    public HistoryReference getSelectedHistoryReference() {
        if (this.hasSelectedMessages()) {
            return this.selectedHistoryReferences.get(0);
        }
        return null;
    }

    @Override
    public List<HistoryReference> getSelectedHistoryReferences() {
        return this.selectedHistoryReferences;
    }
}

