/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.messagelocation;

import com.stackhawk.hste.view.messagelocation.MessageLocationProducer;
import com.stackhawk.hste.view.messagelocation.MessageLocationProducerFocusEvent;
import com.stackhawk.hste.view.messagelocation.MessageLocationProducerFocusListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;

public class MessageLocationProducerFocusListenerAdapter
implements FocusListener {
    private final List<MessageLocationProducerFocusListener> focusListeners;
    private final MessageLocationProducer source;

    public MessageLocationProducerFocusListenerAdapter(MessageLocationProducer source) {
        this.source = source;
        this.focusListeners = new ArrayList<MessageLocationProducerFocusListener>(5);
    }

    public boolean hasFocusListeners() {
        return !this.focusListeners.isEmpty();
    }

    public void addFocusListener(MessageLocationProducerFocusListener focusListener) {
        this.focusListeners.add(focusListener);
    }

    public void removeFocusListener(MessageLocationProducerFocusListener focusListener) {
        this.focusListeners.remove(focusListener);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.focusListeners.isEmpty()) {
            return;
        }
        MessageLocationProducerFocusEvent event = new MessageLocationProducerFocusEvent(this.source, e);
        for (MessageLocationProducerFocusListener focusListener : this.focusListeners) {
            focusListener.focusGained(event);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.focusListeners.isEmpty()) {
            return;
        }
        MessageLocationProducerFocusEvent event = new MessageLocationProducerFocusEvent(this.source, e);
        for (MessageLocationProducerFocusListener focusListener : this.focusListeners) {
            focusListener.focusLost(event);
        }
    }
}

