/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.messagelocation;

import com.stackhawk.hste.model.MessageLocation;
import com.stackhawk.hste.view.messagelocation.MessageLocationHighlight;

public class MessageLocationTableEntry {
    private final LocationUI locationUI;
    private MessageLocationHighlight highlight;
    private MessageLocationHighlight highlightReference;

    public MessageLocationTableEntry(MessageLocation location) {
        this(location, null, null);
    }

    public MessageLocationTableEntry(MessageLocation location, MessageLocationHighlight highlight, MessageLocationHighlight highlightReference) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location must not be null.");
        }
        this.locationUI = new LocationUI(location);
        this.highlight = highlight;
        this.highlightReference = highlightReference;
    }

    public MessageLocationHighlight getHighlight() {
        return this.highlight;
    }

    public void setHighlight(MessageLocationHighlight highlight) {
        this.highlight = highlight;
    }

    public MessageLocationHighlight getHighlightReference() {
        return this.highlightReference;
    }

    public void setHighlightReference(MessageLocationHighlight highlightReference) {
        this.highlightReference = highlightReference;
    }

    public LocationUI getLocationUI() {
        return this.locationUI;
    }

    public MessageLocation getLocation() {
        return this.locationUI.getLocation();
    }

    public static class LocationUI
    implements Comparable<LocationUI> {
        private final MessageLocation location;

        private LocationUI(MessageLocation location) {
            this.location = location;
        }

        public MessageLocation getLocation() {
            return this.location;
        }

        @Override
        public int compareTo(LocationUI other) {
            return this.location.compareTo(other.location);
        }

        public String toString() {
            return this.location.getDescription();
        }
    }
}

