/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.panels;

import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.scan.BaseScannerThread;
import com.stackhawk.hste.scan.BaseScannerThreadManager;
import com.stackhawk.hste.scan.ScanListener;
import com.stackhawk.hste.utils.ThreadUtils;
import com.stackhawk.hste.view.HsteToggleButton;
import com.stackhawk.hste.view.LayoutHelper;
import com.stackhawk.hste.view.ScanPanel;
import com.stackhawk.hste.view.panels.AbstractContextSelectToolbarStatusPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;

public abstract class AbstractScanToolbarStatusPanel
extends AbstractContextSelectToolbarStatusPanel
implements ScanListener {
    private static final long serialVersionUID = -2351280081989616482L;
    private static final Logger LOGGER = LogManager.getLogger(AbstractScanToolbarStatusPanel.class);
    protected static final short TOOLBAR_LOCATION_AFTER_BUTTONS = 10;
    protected static final short TOOLBAR_LOCATION_AFTER_PROGRESS_BAR = 11;
    private JButton startScanButton;
    private JButton stopScanButton;
    private HsteToggleButton pauseScanButton;
    private JProgressBar progressBar;
    private Control.Mode mode = Control.getSingleton().getMode();
    private BaseScannerThreadManager<?> threadManager;

    public AbstractScanToolbarStatusPanel(String prefix, ImageIcon icon, BaseScannerThreadManager<?> threadManager) {
        super(prefix, icon);
        this.threadManager = threadManager;
    }

    @Override
    protected void setupToolbarElements(JToolBar toolbar) {
        int x = 0;
        Insets insets = new Insets(0, 4, 0, 2);
        x = this.addToolBarElements(toolbar, (short)0, x);
        toolbar.add((Component)new JLabel(Constant.messages.getString(this.panelPrefix + ".toolbar.context.label")), LayoutHelper.getGBC(x++, 0, 1, 0.0, insets));
        toolbar.add((Component)this.getContextSelectComboBox(), LayoutHelper.getGBC(x++, 0, 1, 0.0, insets));
        x = this.addToolBarElements(toolbar, (short)1, x);
        toolbar.add((Component)this.getStartScanButton(), LayoutHelper.getGBC(x++, 0, 1, 0.0, insets));
        toolbar.add((Component)this.getPauseScanButton(), LayoutHelper.getGBC(x++, 0, 1, 0.0, insets));
        toolbar.add((Component)this.getStopScanButton(), LayoutHelper.getGBC(x++, 0, 1, 0.0, insets));
        x = this.addToolBarElements(toolbar, (short)10, x);
        toolbar.add((Component)this.getProgressBar(), LayoutHelper.getGBC(x++, 0, 1, 1.0, insets));
        x = this.addToolBarElements(toolbar, (short)11, x);
        toolbar.add((Component)new JLabel(), LayoutHelper.getGBC(x++, 0, 1, 1.0));
        if (this.hasOptions()) {
            toolbar.add((Component)this.getOptionsButton(), LayoutHelper.getGBC(x++, 0, 1, 0.0, insets));
        }
        this.addToolBarElements(toolbar, (short)99, x);
    }

    private JButton getStartScanButton() {
        if (this.startScanButton == null) {
            this.startScanButton = new JButton();
            this.startScanButton.setToolTipText(Constant.messages.getString(this.panelPrefix + ".toolbar.button.start"));
            this.startScanButton.setIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/131.png")));
            this.startScanButton.setEnabled(false);
            this.startScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractScanToolbarStatusPanel.this.startScan(AbstractScanToolbarStatusPanel.this.getSelectedContext());
                }
            });
        }
        return this.startScanButton;
    }

    private JButton getStopScanButton() {
        if (this.stopScanButton == null) {
            this.stopScanButton = new JButton();
            this.stopScanButton.setToolTipText(Constant.messages.getString(this.panelPrefix + ".toolbar.button.stop"));
            this.stopScanButton.setIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/142.png")));
            this.stopScanButton.setEnabled(false);
            this.stopScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractScanToolbarStatusPanel.this.stopScan(AbstractScanToolbarStatusPanel.this.getSelectedContext());
                }
            });
        }
        return this.stopScanButton;
    }

    private JToggleButton getPauseScanButton() {
        if (this.pauseScanButton == null) {
            this.pauseScanButton = new HsteToggleButton();
            this.pauseScanButton.setToolTipText(Constant.messages.getString(this.panelPrefix + ".toolbar.button.pause"));
            this.pauseScanButton.setSelectedToolTipText(Constant.messages.getString(this.panelPrefix + ".toolbar.button.unpause"));
            this.pauseScanButton.setIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/141.png")));
            this.pauseScanButton.setRolloverIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/141.png")));
            this.pauseScanButton.setSelectedIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/131.png")));
            this.pauseScanButton.setRolloverSelectedIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/131.png")));
            this.pauseScanButton.setEnabled(false);
            this.pauseScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AbstractScanToolbarStatusPanel.this.isScanPaused(AbstractScanToolbarStatusPanel.this.getSelectedContext())) {
                        AbstractScanToolbarStatusPanel.this.resumeScan(AbstractScanToolbarStatusPanel.this.getSelectedContext());
                    } else {
                        AbstractScanToolbarStatusPanel.this.pauseScan(AbstractScanToolbarStatusPanel.this.getSelectedContext());
                    }
                }
            });
        }
        return this.pauseScanButton;
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setSize(new Dimension(80, 20));
            this.progressBar.setStringPainted(true);
            this.progressBar.setEnabled(false);
        }
        return this.progressBar;
    }

    @Override
    protected void contextSelected(Context context) {
        if (context == null) {
            this.resetScanButtonsAndProgressBarStates(false);
            super.contextSelected(context);
            return;
        }
        if (Control.Mode.safe.equals((Object)this.mode)) {
            super.contextSelected(context);
            return;
        }
        if (Control.Mode.protect.equals((Object)this.mode) && !context.isInScope()) {
            this.resetScanButtonsAndProgressBarStates(false);
            super.contextSelected(context);
            return;
        }
        if (this.isScanStarted(context)) {
            this.getStartScanButton().setEnabled(false);
            this.getStopScanButton().setEnabled(true);
            this.getPauseScanButton().setEnabled(true);
            this.getPauseScanButton().setSelected(this.isScanPaused(context));
            this.getProgressBar().setEnabled(true);
        } else {
            this.resetScanButtonsAndProgressBarStates(true);
        }
        this.getProgressBar().setValue(this.getScanProgress(context));
        this.getProgressBar().setMaximum(this.getScanMaximumProgress(context));
        super.contextSelected(context);
    }

    private void resetScanButtonsAndProgressBarStates(boolean allowStartScan) {
        this.setScanButtonsAndProgressBarStates(false, false, allowStartScan);
        this.getProgressBar().setValue(0);
    }

    private void setScanButtonsAndProgressBarStates(boolean isStarted, boolean isPaused, boolean allowStartScan) {
        if (isStarted) {
            this.getStartScanButton().setEnabled(false);
            this.getPauseScanButton().setEnabled(true);
            this.getPauseScanButton().setSelected(isPaused);
            this.getStopScanButton().setEnabled(true);
            this.getProgressBar().setEnabled(true);
        } else {
            this.getStartScanButton().setEnabled(allowStartScan);
            this.getStopScanButton().setEnabled(false);
            this.getPauseScanButton().setEnabled(false);
            this.getPauseScanButton().setSelected(false);
            this.getProgressBar().setEnabled(false);
        }
    }

    public void sessionModeChanged(Control.Mode mode) {
        this.mode = mode;
        switch (mode) {
            case attack: 
            case standard: 
            case protect: {
                this.getContextSelectComboBox().setEnabled(true);
                if (this.getSelectedContext() == null) break;
                this.contextSelected(this.getSelectedContext());
                break;
            }
            case safe: {
                this.resetScanButtonsAndProgressBarStates(false);
                this.getContextSelectComboBox().setEnabled(false);
            }
        }
    }

    protected void pauseScan(Context context) {
        LOGGER.debug("Access Control pause on Context: {}", (Object)context);
        ((BaseScannerThread)this.threadManager.getScannerThread(context.getId())).pauseScan();
    }

    protected void resumeScan(Context context) {
        LOGGER.debug("Access Control resume on Context: {}", (Object)context);
        ((BaseScannerThread)this.threadManager.getScannerThread(context.getId())).resumeScan();
    }

    protected void stopScan(Context context) {
        LOGGER.debug("Access Control stop on Context: {}", (Object)context);
        ((BaseScannerThread)this.threadManager.getScannerThread(context.getId())).stopScan();
    }

    protected boolean isScanStarted(Context context) {
        return ((BaseScannerThread)this.threadManager.getScannerThread(context.getId())).isRunning();
    }

    protected boolean isScanPaused(Context context) {
        return ((BaseScannerThread)this.threadManager.getScannerThread(context.getId())).isPaused();
    }

    protected int getScanProgress(Context context) {
        return ((BaseScannerThread)this.threadManager.getScannerThread(context.getId())).getScanProgress();
    }

    protected int getScanMaximumProgress(Context context) {
        return ((BaseScannerThread)this.threadManager.getScannerThread(context.getId())).getScanMaximumProgress();
    }

    @Override
    public void scanStarted(final int contextId) {
        Runnable handler = new Runnable(){

            @Override
            public void run() {
                LOGGER.debug("ScanStarted {} on context {}", (Object)AbstractScanToolbarStatusPanel.this.panelPrefix, (Object)contextId);
                if (AbstractScanToolbarStatusPanel.this.getSelectedContext() != null && contextId == AbstractScanToolbarStatusPanel.this.getSelectedContext().getId()) {
                    AbstractScanToolbarStatusPanel.this.setScanButtonsAndProgressBarStates(true, false, false);
                    AbstractScanToolbarStatusPanel.this.getProgressBar().setValue(0);
                }
            }
        };
        try {
            ThreadUtils.invokeAndWait(handler);
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.error("Error while starting scan: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void scanFinished(final int contextId) {
        Runnable handler = new Runnable(){

            @Override
            public void run() {
                LOGGER.debug("ScanFinished {} on context {}", (Object)AbstractScanToolbarStatusPanel.this.panelPrefix, (Object)contextId);
                if (AbstractScanToolbarStatusPanel.this.getSelectedContext() != null && contextId == AbstractScanToolbarStatusPanel.this.getSelectedContext().getId()) {
                    AbstractScanToolbarStatusPanel.this.setScanButtonsAndProgressBarStates(false, false, true);
                }
            }
        };
        try {
            ThreadUtils.invokeAndWait(handler);
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.error("Error while finishing scan: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void scanProgress(final int contextId, final int progress, final int maximum) {
        Runnable handler = new Runnable(){

            @Override
            public void run() {
                LOGGER.debug("scanProgress {} on context {} {}", (Object)AbstractScanToolbarStatusPanel.this.panelPrefix, (Object)contextId, (Object)progress);
                if (AbstractScanToolbarStatusPanel.this.getSelectedContext() != null && contextId == AbstractScanToolbarStatusPanel.this.getSelectedContext().getId()) {
                    AbstractScanToolbarStatusPanel.this.getProgressBar().setValue(progress);
                    AbstractScanToolbarStatusPanel.this.getProgressBar().setMaximum(maximum);
                }
            }
        };
        try {
            ThreadUtils.invokeAndWait(handler);
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.error("Error while updating progress: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    protected abstract void startScan(Context var1);
}

