/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.panelsearch;

import com.stackhawk.hste.view.panelsearch.ComponentSearchProvider;
import com.stackhawk.hste.view.panelsearch.FoundComponent;
import com.stackhawk.hste.view.panelsearch.SearchQuery;
import com.stackhawk.hste.view.panelsearch.items.ButtonSearch;
import com.stackhawk.hste.view.panelsearch.items.ComboBoxElementSearch;
import com.stackhawk.hste.view.panelsearch.items.ComboBoxSearch;
import com.stackhawk.hste.view.panelsearch.items.ComponentSearch;
import com.stackhawk.hste.view.panelsearch.items.ContainerSearch;
import com.stackhawk.hste.view.panelsearch.items.JComponentSearch;
import com.stackhawk.hste.view.panelsearch.items.JxLabelSearch;
import com.stackhawk.hste.view.panelsearch.items.LabelSearch;
import com.stackhawk.hste.view.panelsearch.items.SpinnerSearch;
import com.stackhawk.hste.view.panelsearch.items.TabbedPaneElementSearch;
import com.stackhawk.hste.view.panelsearch.items.TabbedPaneSearch;
import com.stackhawk.hste.view.panelsearch.items.TableCellElementSearch;
import com.stackhawk.hste.view.panelsearch.items.TableSearch;
import com.stackhawk.hste.view.panelsearch.items.TextFieldSearch;
import com.stackhawk.hste.view.panelsearch.items.TitledBorderSearch;
import com.stackhawk.hste.view.panelsearch.items.TreeNodeElementSearch;
import com.stackhawk.hste.view.panelsearch.items.TreeSearch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Search {
    public static final List<ComponentSearch> DefaultComponentSearchItems = Arrays.asList(new TreeSearch(), new ButtonSearch(), new TreeNodeElementSearch(), new JxLabelSearch(), new LabelSearch(), new SpinnerSearch(), new TextFieldSearch(), new ComboBoxSearch(), new ComboBoxElementSearch(), new TableSearch(), new TableCellElementSearch(), new TabbedPaneSearch(), new TabbedPaneElementSearch(), new TitledBorderSearch(), new JComponentSearch(), new ContainerSearch());
    private final List<ComponentSearch> componentSearchItems;

    public Search(List<ComponentSearch> componentSearchItems) {
        if (componentSearchItems == null) {
            throw new IllegalArgumentException("componentSearchItems is null");
        }
        this.componentSearchItems = new ArrayList<ComponentSearch>(componentSearchItems);
    }

    public ArrayList<FoundComponent> searchFor(Object component, SearchQuery query) {
        return this.searchFor(new Object[]{component}, query);
    }

    public ArrayList<FoundComponent> searchFor(Object[] components, SearchQuery query) {
        ArrayList<FoundComponent> foundComponents = new ArrayList<FoundComponent>();
        for (Object component : components) {
            for (ComponentSearch componentSearchItem : this.componentSearchItems) {
                if (!componentSearchItem.isResponsible(component)) continue;
                if (componentSearchItem.isSearchMatching(component, query)) {
                    foundComponents.add(new FoundComponent(component));
                }
                Object[] childComponents = componentSearchItem.getComponents(component);
                ArrayList<FoundComponent> foundChildComponents = this.searchFor(childComponents, query);
                for (FoundComponent foundChildComponent : foundChildComponents) {
                    foundChildComponent.addParent(component);
                    foundComponents.add(foundChildComponent);
                }
            }
        }
        return foundComponents;
    }

    public void registerComponentSearch(ComponentSearch componentSearch) {
        this.componentSearchItems.add(0, componentSearch);
    }

    public void registerComponentSearch(ComponentSearchProvider componentSearchProvider) {
        List<ComponentSearch> componentSearches = componentSearchProvider.getComponentSearch();
        if (componentSearches != null) {
            for (ComponentSearch componentSearch : componentSearches) {
                this.registerComponentSearch(componentSearch);
            }
        }
    }

    public void removeComponentSearch(ComponentSearch componentSearch) {
        this.componentSearchItems.remove(componentSearch);
    }

    public void removeComponentSearch(ComponentSearchProvider componentSearchProvider) {
        List<ComponentSearch> componentSearches = componentSearchProvider.getComponentSearch();
        if (componentSearches != null) {
            for (ComponentSearch componentSearch : componentSearches) {
                this.removeComponentSearch(componentSearch);
            }
        }
    }
}

