/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.popup;

import com.stackhawk.hste.view.messagecontainer.http.HttpMessageContainer;
import com.stackhawk.hste.view.messagecontainer.http.SelectableHistoryReferencesContainer;
import com.stackhawk.hste.view.messagecontainer.http.SingleHistoryReferenceContainer;
import com.stackhawk.hste.view.popup.PopupMenuHttpMessageContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;

public class PopupMenuHistoryReferenceContainer
extends PopupMenuHttpMessageContainer {
    private static final long serialVersionUID = 1L;

    public PopupMenuHistoryReferenceContainer(String label) {
        this(label, false);
    }

    public PopupMenuHistoryReferenceContainer(String label, boolean multiSelect) {
        super(label, multiSelect);
    }

    @Override
    protected boolean isEnable(HttpMessageContainer httpMessageContainer) {
        return httpMessageContainer instanceof SelectableHistoryReferencesContainer || httpMessageContainer instanceof SingleHistoryReferenceContainer;
    }

    @Override
    protected boolean isButtonEnabledForSelectedMessages(HttpMessageContainer httpMessageContainer) {
        return this.isButtonEnabledForSelectedHistoryReferences(this.getSelectedHistoryReferences(httpMessageContainer));
    }

    @Override
    protected boolean isSelectedMessagesInSessionScope(HttpMessageContainer httpMessageContainer) {
        Session session = Model.getSingleton().getSession();
        for (HistoryReference historyReference : this.getSelectedHistoryReferences(httpMessageContainer)) {
            if (session.isInScope(historyReference)) continue;
            return false;
        }
        return true;
    }

    protected List<HistoryReference> getSelectedHistoryReferences(HttpMessageContainer httpMessageContainer) {
        SingleHistoryReferenceContainer singleContainer;
        if (httpMessageContainer instanceof SelectableHistoryReferencesContainer) {
            return ((SelectableHistoryReferencesContainer)httpMessageContainer).getSelectedHistoryReferences();
        }
        if (httpMessageContainer instanceof SingleHistoryReferenceContainer && !(singleContainer = (SingleHistoryReferenceContainer)httpMessageContainer).isEmpty()) {
            ArrayList<HistoryReference> selectedHistoryReferences = new ArrayList<HistoryReference>(1);
            selectedHistoryReferences.add(singleContainer.getHistoryReference());
            return selectedHistoryReferences;
        }
        return Collections.emptyList();
    }

    protected boolean isButtonEnabledForSelectedHistoryReferences(List<HistoryReference> historyReferences) {
        for (HistoryReference historyReference : historyReferences) {
            if (historyReference == null || this.isButtonEnabledForHistoryReference(historyReference)) continue;
            return false;
        }
        return true;
    }

    protected boolean isButtonEnabledForHistoryReference(HistoryReference historyReference) {
        return historyReference.getHistoryType() != 0;
    }
}

