/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.popup;

import com.stackhawk.hste.view.messagecontainer.MessageContainer;
import com.stackhawk.hste.view.messagecontainer.http.HttpMessageContainer;
import com.stackhawk.hste.view.messagecontainer.http.SelectableHttpMessagesContainer;
import com.stackhawk.hste.view.messagecontainer.http.SingleHttpMessageContainer;
import com.stackhawk.hste.view.popup.ExtensionPopupMenuMessageContainer;
import com.stackhawk.hste.view.popup.PopupMenuUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.network.HttpMessage;

public class PopupMenuHttpMessageContainer
extends ExtensionPopupMenuMessageContainer {
    private static final long serialVersionUID = -5266647403287261225L;
    private Invoker invoker = null;
    private boolean buttonEnabledForEnableChildren = true;
    private boolean processExtensionPopupChildren = true;
    private final boolean multiSelect;

    public PopupMenuHttpMessageContainer(String label) {
        this(label, false);
    }

    public PopupMenuHttpMessageContainer(String label, boolean multiSelect) {
        super(label);
        this.multiSelect = multiSelect;
    }

    public final void setButtonStateOverriddenByChildren(boolean buttonEnabledForEnableChildren) {
        this.buttonEnabledForEnableChildren = buttonEnabledForEnableChildren;
    }

    public final boolean isButtonStateOverriddenByChildren() {
        return this.buttonEnabledForEnableChildren;
    }

    public final void setProcessExtensionPopupChildren(boolean processExtensionPopupChildren) {
        this.processExtensionPopupChildren = processExtensionPopupChildren;
    }

    public final boolean isProcessExtensionPopupChildren() {
        return this.processExtensionPopupChildren;
    }

    public final boolean isMultiSelect() {
        return this.multiSelect;
    }

    protected final Invoker getInvoker() {
        return this.invoker;
    }

    @Override
    public boolean isEnableForMessageContainer(MessageContainer<?> messageContainer) {
        this.invoker = null;
        if (!(messageContainer instanceof HttpMessageContainer)) {
            return false;
        }
        HttpMessageContainer httpMessageContainer = (HttpMessageContainer)messageContainer;
        if (!this.isEnable(httpMessageContainer)) {
            return false;
        }
        this.invoker = PopupMenuHttpMessageContainer.getInvoker(httpMessageContainer);
        if (!this.isEnableForInvoker(this.invoker, httpMessageContainer)) {
            this.invoker = null;
            return false;
        }
        boolean enabled = false;
        if (this.isProcessExtensionPopupChildren()) {
            boolean childrenEnable = this.processExtensionPopupChildren(PopupMenuUtils.getPopupMenuInvokerWrapper(httpMessageContainer));
            if (this.isButtonStateOverriddenByChildren()) {
                enabled = childrenEnable;
            }
        }
        if (!this.isProcessExtensionPopupChildren() || this.isProcessExtensionPopupChildren() && !this.isButtonStateOverriddenByChildren()) {
            enabled = this.isButtonEnabledForHttpMessageContainerState(httpMessageContainer);
        }
        if (enabled && !this.isSafe()) {
            Control.Mode mode = Control.getSingleton().getMode();
            if (mode.equals((Object)Control.Mode.protect)) {
                enabled = this.isSelectedMessagesInSessionScope(httpMessageContainer);
            } else if (mode.equals((Object)Control.Mode.safe)) {
                enabled = false;
            }
        }
        this.setEnabled(enabled);
        return true;
    }

    protected boolean isEnable(HttpMessageContainer httpMessageContainer) {
        return httpMessageContainer instanceof SelectableHttpMessagesContainer || httpMessageContainer instanceof SingleHttpMessageContainer;
    }

    protected static final Invoker getInvoker(HttpMessageContainer httpMessageContainer) {
        Invoker invoker;
        switch (httpMessageContainer.getName()) {
            case "History Table": {
                invoker = Invoker.HISTORY_PANEL;
                break;
            }
            case "treeSite": {
                invoker = Invoker.SITES_PANEL;
                break;
            }
            case "treeAlert": {
                invoker = Invoker.ALERTS_PANEL;
                break;
            }
            case "SearchHttpMessageContainer": {
                invoker = Invoker.SEARCH_PANEL;
                break;
            }
            case "SpiderHttpMessageContainer": {
                invoker = Invoker.SPIDER_PANEL;
                break;
            }
            case "ActiveScanMessageContainer": {
                invoker = Invoker.ACTIVE_SCANNER_PANEL;
                break;
            }
            case "fuzz.httpfuzzerResultsContentPanel": {
                invoker = Invoker.FUZZER_PANEL;
                break;
            }
            case "ForcedBrowseMessageContainer": {
                invoker = Invoker.FORCED_BROWSE_PANEL;
                break;
            }
            default: {
                invoker = Invoker.UNKNOWN;
            }
        }
        return invoker;
    }

    protected boolean isEnableForInvoker(Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return true;
    }

    protected boolean isButtonEnabledForHttpMessageContainerState(HttpMessageContainer httpMessageContainer) {
        boolean enabled = this.isButtonEnabledForNumberOfSelectedMessages(httpMessageContainer);
        if (enabled) {
            enabled = this.isButtonEnabledForSelectedMessages(httpMessageContainer);
        }
        return enabled;
    }

    protected boolean isButtonEnabledForNumberOfSelectedMessages(HttpMessageContainer httpMessageContainer) {
        return this.isButtonEnabledForNumberOfSelectedMessages(this.getNumberOfSelectedMessages(httpMessageContainer));
    }

    protected boolean isButtonEnabledForSelectedMessages(HttpMessageContainer httpMessageContainer) {
        return this.isButtonEnabledForSelectedMessages(this.getSelectedMessages(httpMessageContainer));
    }

    protected int getNumberOfSelectedMessages(HttpMessageContainer httpMessageContainer) {
        if (httpMessageContainer instanceof SelectableHttpMessagesContainer) {
            return ((SelectableHttpMessagesContainer)httpMessageContainer).getNumberOfSelectedMessages();
        }
        if (httpMessageContainer instanceof SingleHttpMessageContainer) {
            return ((SingleHttpMessageContainer)httpMessageContainer).isEmpty() ? 0 : 1;
        }
        return 0;
    }

    protected boolean isButtonEnabledForNumberOfSelectedMessages(int numberOfSelectedMessages) {
        if (numberOfSelectedMessages == 0) {
            return false;
        }
        return numberOfSelectedMessages <= 1 || this.isMultiSelect();
    }

    protected List<HttpMessage> getSelectedMessages(HttpMessageContainer httpMessageContainer) {
        SingleHttpMessageContainer singleContainer;
        if (httpMessageContainer instanceof SelectableHttpMessagesContainer) {
            return ((SelectableHttpMessagesContainer)httpMessageContainer).getSelectedMessages();
        }
        if (httpMessageContainer instanceof SingleHttpMessageContainer && !(singleContainer = (SingleHttpMessageContainer)httpMessageContainer).isEmpty()) {
            ArrayList<HttpMessage> selectedHttpMessages = new ArrayList<HttpMessage>(1);
            selectedHttpMessages.add((HttpMessage)singleContainer.getMessage());
            return selectedHttpMessages;
        }
        return Collections.emptyList();
    }

    protected boolean isButtonEnabledForSelectedMessages(List<HttpMessage> httpMessages) {
        for (HttpMessage httpMessage : httpMessages) {
            if (httpMessage == null || this.isButtonEnabledForSelectedHttpMessage(httpMessage)) continue;
            return false;
        }
        return true;
    }

    protected boolean isButtonEnabledForSelectedHttpMessage(HttpMessage httpMessage) {
        return true;
    }

    protected boolean isSelectedMessagesInSessionScope(HttpMessageContainer httpMessageContainer) {
        for (HttpMessage httpMessage : this.getSelectedMessages(httpMessageContainer)) {
            if (httpMessage == null || httpMessage.isInScope()) continue;
            return false;
        }
        return true;
    }

    protected static enum Invoker {
        SITES_PANEL,
        HISTORY_PANEL,
        ALERTS_PANEL,
        ACTIVE_SCANNER_PANEL,
        SEARCH_PANEL,
        SPIDER_PANEL,
        FUZZER_PANEL,
        FORCED_BROWSE_PANEL,
        UNKNOWN;

    }
}

