/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.popup;

import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.view.popup.PopupMenuItemIncludeInContext;
import com.stackhawk.hste.view.popup.PopupMenuItemSiteNodeContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;

public class PopupMenuItemContextInclude
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 3790264690466717219L;
    private List<ExtensionPopupMenuItem> subMenus = new ArrayList<ExtensionPopupMenuItem>();

    public PopupMenuItemContextInclude() {
        super("IncludeInContextX", true);
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.include.popup");
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public boolean isDummyItem() {
        return true;
    }

    @Override
    public void performAction(SiteNode sn) {
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode sn) {
        this.reCreateSubMenu();
        return false;
    }

    protected void reCreateSubMenu() {
        Vector<JMenuItem> mainPopupMenuItems = View.getSingleton().getPopupList();
        for (ExtensionPopupMenuItem menu : this.subMenus) {
            mainPopupMenuItems.remove(menu);
        }
        this.subMenus.clear();
        Session session = Model.getSingleton().getSession();
        List<Context> contexts = session.getContexts();
        for (Context context : contexts) {
            ExtensionPopupMenuItem piicm = this.createPopupIncludeInContextMenu(context);
            piicm.setMenuIndex(this.getMenuIndex());
            mainPopupMenuItems.add(piicm);
            this.subMenus.add(piicm);
        }
        ExtensionPopupMenuItem piicm = this.createPopupIncludeInContextMenu();
        mainPopupMenuItems.add(piicm);
        this.subMenus.add(piicm);
    }

    protected ExtensionPopupMenuItem createPopupIncludeInContextMenu() {
        return new PopupMenuItemIncludeInContext();
    }

    protected ExtensionPopupMenuItem createPopupIncludeInContextMenu(Context context) {
        return new PopupMenuItemIncludeInContext(context);
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

